<?php

namespace App\Models;

use CodeIgniter\Model;

class CategoryModel extends Model
{
    protected $table = 'categories';
    protected $primaryKey = 'id';
    protected $allowedFields = ['category_key', 'category', 'category_status'];

    protected $tableChild = 'subcategories';

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function checkParent(string $param): ?object
    {
        return $this->db->table($this->table)
            ->where('category', $param)
            ->get()
            ->getRow();
    }

    public function addParent(array $data): int|bool
    {
        $this->db->table($this->table)->insert($data);
        if ($this->db->affectedRows() > 0) {
            return $this->db->insertID();
        }
        return false;
    }

    public function getAllParent(): array
    {
        return $this->db->table($this->table)
            ->select('*')
            ->get()
            ->getResultArray();
    }

    public function getAllParentForSite(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('category_status', 1)
            ->get();

        $result = $query->getResultArray();
        return !empty($result) ? $result : false;
    }

    public function getParentByKey(string $param): array
    {
        return $this->db->table($this->table)
            ->select('*')
            ->where('category_key', $param)
            ->get()
            ->getRowArray();
    }

    public function updateParentByKey(string $param, array $data): bool
    {
        return $this->db->table($this->table)
            ->where('category_key', $param)
            ->update($data);
    }

    public function deleteParentByKey(string $param): bool
    {
        $result = $this->db->table($this->table)
            ->where('category_key', $param)
            ->delete();

        return $this->db->affectedRows() > 0;
    }

    public function getAllParentWithChild(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->join($this->tableChild, "$this->tableChild.category_key = $this->table.category_key")
            ->get();

        $result = $query->getResultArray();
        return !empty($result) ? $result : false;
    }
}