<?php

namespace App\Models;

use CodeIgniter\Model;

class BareactModel extends Model
{
    protected $table = 'bareacts';
    protected $primaryKey = 'ba_id';
    protected $allowedFields = ['ba_title', 'ba_key', 'ba_status', 'category_key'];

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function addParent($data)
    {
        return $this->insert($data) ? $this->getInsertID() : false;
    }

    public function getAllParent()
    {
        return $this->orderBy('ba_id', 'DESC')->findAll();
    }

    public function getAllParentForSite()
    {
        return $this->where('ba_status', 1)
                    ->orderBy('ba_title', 'ASC')
                    ->findAll();
    }

    public function getParentByKey($param)
    {
        return $this->where('ba_key', $param)->first();
    }

    public function updateParentByKey($param, $data)
    {
        return $this->where('ba_key', $param)->set($data)->update();
    }

    public function deleteParentByKey($param)
    {
        return $this->where('ba_key', $param)->delete();
    }
}