<?php

namespace App\Models;

use CodeIgniter\Model;

class AuthorModel extends Model
{
    protected $table = 'authors';
    protected $primaryKey = 'author_id';
    protected $allowedFields = ['author_name', 'author_key', 'author_status', 'article_like'];

    public function addParent($data)
    {
        return $this->insert($data) ? $this->getInsertID() : false;
    }

    public function getAllParent()
    {
        return $this->orderBy('author_id', 'DESC')->findAll();
    }

    public function getAllParentForSite()
    {
        return $this->where('author_status', 1)
                    ->orderBy('author_id', 'DESC')
                    ->findAll();
    }

    public function getAllTopParentForSite()
    {
        $authors = $this->where('author_status', 1)->findAll();
        return array_filter($authors, function($value) {
            return !empty($value['article_like']);
        });
    }

    public function getParentByKey($param)
    {
        return $this->where('author_key', $param)->first();
    }

    public function updateParentByKey($param, $data)
    {
        return $this->where('author_key', $param)->set($data)->update();
    }

    public function deleteParentByKey($param)
    {
        return $this->where('author_key', $param)->delete();
    }
}