<?php

namespace App\Models;

use CodeIgniter\Model;

class ArticleModel extends Model
{
    protected $table = 'article';
    protected $primaryKey = 'article_id';
    protected $allowedFields = ['article_key', 'category_key', 'article_author', 'article_title', 'article_content', 'article_status', 'article_like'];

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function addParent(array $data): int|bool
    {
        $this->db->table($this->table)->insert($data);
        if ($this->db->affectedRows() > 0) {
            return $this->db->insertID();
        }
        return false;
    }

    public function getAllParent(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->join('categories', 'categories.category_key = article.category_key')
            ->join('authors', 'authors.author_key = article.article_author')
            ->orderBy('article_id', 'DESC')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getAllParentForSite()
{
    $result = $this->select('article.*, categories.*, authors.*')
                   ->where('article_status', 1)
                   ->join('categories', 'categories.category_key = article.category_key')
                   ->join('authors', 'authors.author_key = article.article_author')
                   ->orderBy('article_id', 'DESC')
                   ->findAll();

    return $result ? $result : [];
}

    public function getAllTopParentForSite(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('article_status', 1)
            ->join('categories', 'categories.category_key = article.category_key')
            ->join('authors', 'authors.author_key = article.article_author')
            ->get();

        $data = $query->getResultArray();
        if (empty($data)) {
            return false;
        }

        return array_filter($data, fn($value) => !empty($value['article_like']));
    }

    public function getParentByKey(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('article_key', $param)
            ->join('categories', 'categories.category_key = article.category_key')
            ->join('authors', 'authors.author_key = article.article_author')
            ->orderBy('article.article_id')
            ->get();

        return $query->getRowArray() ?: false;
    }

    public function getParentByTitle(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->like('article_title', $param)
            ->join('categories', 'categories.category_key = article.category_key')
            ->join('authors', 'authors.author_key = article.article_author')
            ->get();

        return $query->getRowArray() ?: false;
    }

    public function getAllParentByTitle(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->like('article_title', $param)
            ->join('categories', 'categories.category_key = article.category_key')
            ->join('authors', 'authors.author_key = article.article_author')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getParentByCategoryKey(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('category_key', $param)
            ->orderBy('article.article_id')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function updateParentByKey(string $param, array $data): bool
    {
        return $this->db->table($this->table)
            ->where('article_key', $param)
            ->update($data);
    }

    public function deleteParentByKey(string $param): bool
    {
        return $this->db->table($this->table)
            ->where('article_key', $param)
            ->delete();
    }
}