<?php

namespace App\Models;

use CodeIgniter\Model;

class AdminModel extends Model
{
    protected $table = 'admin';
    protected $primaryKey = 'admin_id';
    protected $allowedFields = ['admin_name', 'admin_email', 'admin_password', 'admin_profile_img'];

    protected $session;

    public function __construct()
    {
        parent::__construct();
        $this->session = \Config\Services::session();
    }

    public function getUserByEmail($param)
    {
        return $this->where('admin_email', $param)->first();
    }

    public function authenticateAdminUser($mUserName, $mPassword)
    {
        $admin = $this->where('admin_email', $mUserName)
                      ->where('admin_password', $mPassword)
                      ->first();

        if ($admin) {
            $this->setSessionAdmin($admin);
            return true;
        }
        return false;
    }

    public function setSessionAdmin($data)
    {
        $this->session->set([
            'login_admin_id' => $data['admin_id'],
            'login_admin_name' => $data['admin_name'],
            'login_admin_email' => $data['admin_email'],
            'login_admin_pic' => $data['admin_profile_img']
        ]);
    }
}