<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class Users extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $usersModel;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->usersModel = model('UsersModel');
        $this->session = \Config\Services::session();
        $this->email = \Config\Services::email();
        $this->validation = \Config\Services::validation();

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function index()
    {
        $db = \Config\Database::connect();
        $builder = $db->table('users');

        // Get total number of users
        $totalUsers = $builder->countAllResults(false);

        // Set up pagination
        $perPage = 10;
        $page = $this->request->getVar('page') ? (int)$this->request->getVar('page') : 1;
        $offset = ($page - 1) * $perPage;

        // Fetch users for current page
        $users = $builder->select('user_key, user_name, user_email, user_mobile, user_date_added, user_plan, user_payment_status, user_status')
                         ->limit($perPage, $offset)
                         ->get()
                         ->getResultArray();

        $data = [
            'users' => $users,
            'pager' => [
                'total' => $totalUsers,
                'perPage' => $perPage,
                'currentPage' => $page,
                'lastPage' => ceil($totalUsers / $perPage),
                'startNum' => $offset + 1,
            ],
        ];

        return view('admin/users', $data);
    }

    public function extend()
    {
        $mAdminId = $this->session->get('login_admin_id');
        if (!empty($mAdminId)) {
            $data['navbar'] = "users";
            $data['users'] = $this->usersModel->getAllParent();
            return view('admin/users_extend', $data);
        } else {
            return view('admin/signin');
        }
    }

    public function sendReminderLink($param)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if (!empty($mAdminId)) {
            $data['navbar'] = "users";
            $mIsAuthenticated = $this->usersModel->getParentByKey($param);

            $mName = $mIsAuthenticated['user_name'];
            $mEmail = $mIsAuthenticated['user_email'];
            $mKey = $mIsAuthenticated['user_key'];

            $message = "
<html>
<head>
</head>
<body>
<h3>Dear $mName,</h3>
<p>Thank you for Choosing Daksha Legal to stay updated on the latest legal judgments, articles, and much more.</p>
<p>Your Subscription to Daksha Legal is currently due, please renew your account to stay updated on the latest Legal Judgments, Articles, and much more. Thank you.</p>
<p>You can also renew your account through UPI, all you need to do is scan the QR code and share your receipt to our number 9980065416 and we'll take care of the rest.</p>
<p>Click the link below if you would like to make your payment by any other method.</p>
<h4>
Thank You
<br>
www.DakshaLegal.com
</h4>
</body>
</html>";

            $this->email->setFrom('nithin@dakshalegal.com', 'Daksha Legal');
            $this->email->setTo($mEmail);
            $this->email->setSubject('Reminder');
            $this->email->setMessage($message);
            $this->email->send();
            $this->session->setFlashdata('success', 'Reminder sent successfully.');

            return redirect()->to('admin/users');
        } else {
            return view('admin/signin');
        }
    }

    public function addUser()
    {
        $mAdminId = $this->session->get('login_admin_id');
        if (!empty($mAdminId)) {
            $data['navbar'] = "users";
            $data['users'] = $this->usersModel->getAllParent();
            return view('admin/add_user', $data);
        } else {
            return view('admin/signin');
        }
    }

    public function edit($param = null)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if (!empty($mAdminId)) {
            if ($param) {
                $data['navbar'] = "users";
                $data['user'] = $this->usersModel->getParentByKey($param);
                return view('admin/edit_user', $data);
            } else {
                $this->session->setFlashdata('error', 'Something went wrong, Please try again.');
                return redirect()->to('admin/users');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionUpdate($param = null)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            if ($param) {
                $data['navbar'] = "users";
                if ($this->request->getMethod() === 'POST') {
                    $rules = [
                        'name' => 'required',
                        'email' => 'required|valid_email',
                    ];

                    if (!$this->validate($rules)) {
                        $this->session->setFlashdata('error', 'Validation Error.');
                        return redirect()->to('admin/users/edit/' . $param)->withInput();
                    } else {
                        $user = $this->usersModel->getParentByKey($param);
                        $mName = $this->request->getPost('name');
                        $mEmail = $this->request->getPost('email');
                        $mMobile = $this->request->getPost('mobile');

                        if ($mEmail == $user['user_email']) {
                            $data = [
                                'user_email' => $mEmail,
                                'user_name' => $mName,
                                'user_mobile' => $mMobile,
                            ];
                            $mInsert = $this->usersModel->updateParentByKey($param, $data);
                            if ($mInsert) {
                                $this->session->setFlashdata('success', $mName . ' updated.');
                                return redirect()->to('admin/users/edit/' . $param);
                            } else {
                                $this->session->setFlashdata('error', 'Something went wrong, Please try again.');
                                return redirect()->to('admin/users/edit/' . $param);
                            }
                        } else {
                            $userExists = $this->usersModel->checkUser($mEmail);
                            if (!$userExists) {
                                $data = [
                                    'user_email' => $mEmail,
                                    'user_name' => $mName,
                                ];
                                $mInsert = $this->usersModel->updateParentByKey($param, $data);
                                if ($mInsert) {
                                    $this->session->setFlashdata('success', $mName . ' updated.');
                                    return redirect()->to('admin/users/edit/' . $param);
                                } else {
                                    $this->session->setFlashdata('error', 'Something went wrong, Please try again.');
                                    return redirect()->to('admin/users/edit/' . $param);
                                }
                            } else {
                                $this->session->setFlashdata('error', 'This email has been already taken.');
                                return redirect()->to('admin/users/edit/' . $param);
                            }
                        }
                    }
                } else {
                    $this->session->setFlashdata('error', 'Something went wrong.');
                    return redirect()->to('admin/users/edit/' . $param);
                }
            } else {
                $this->session->setFlashdata('error', 'Something went wrong.');
                return redirect()->to('admin/users');
            }
        } else {
            return redirect()->to('admin/users');
        }
    }

    public function actionChangePassword($param = null)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            if ($param) {
                $data['navbar'] = "users";
                if ($this->request->getMethod() === 'POST') {
                    $mPassword = $this->request->getPost('password');
                    $mSecretPassword = base64_encode(utf8_encode($mPassword));

                    $data = [
                        'user_password' => $mSecretPassword,
                    ];
                    $mInsert = $this->usersModel->updateParentByKey($param, $data);
                    if ($mInsert) {
                        $this->session->setFlashdata('success', 'Password changed successfully.');
                        return redirect()->to('admin/users');
                    } else {
                        $this->session->setFlashdata('error', 'Something went wrong, Please try again.');
                        return redirect()->to('admin/users');
                    }
                } else {
                    $this->session->setFlashdata('error', 'Something went wrong.');
                    return redirect()->to('admin/users');
                }
            } else {
                $this->session->setFlashdata('error', 'Something went wrong.');
                return redirect()->to('admin/users');
            }
        } else {
            return redirect()->to('admin/users');
        }
    }

    public function signup()
    {
        $data['home'] = "users";
        return view('admin/add_user', $data);
    }

    public function signin()
    {
        $data['home'] = "users";
        return view('signin', $data);
    }

    public function actionSignin()
    {
        $data['navbar'] = "";
        if ($this->request->getMethod() === 'POST') {
            $rules = [
                'email' => 'required|valid_email',
                'password' => 'required|min_length[6]|max_length[13]',
            ];

            if (!$this->validate($rules)) {
                $this->session->setFlashdata('error', 'Validation Error');
                return view('login', $data);
            } else {
                $mEmail = $this->request->getPost('email');
                $mPassword = $this->request->getPost('password');
                $mSecretPassword = base64_encode(utf8_encode($mPassword));

                $mIsAuthenticated = $this->usersModel->authenticateUser($mEmail, $mSecretPassword);
                if ($mIsAuthenticated == TRUE) {
                    $mSessionName = $this->session->get('session_name');
                    $this->session->setFlashdata('success', 'Welcome' . " " . $mSessionName);
                    return redirect()->to('home');
                } else {
                    $this->session->setFlashdata('error', 'User not found.');
                    return view('signin', $data);
                }
            }
        } else {
            $this->session->setFlashdata('error', 'Something went wrong.');
            return view('signin', $data);
        }
    }

    public function actionAdd()
    {
        $data['navbar'] = "users";
        if ($this->request->getMethod() === 'POST') {
            $rules = [
                'name' => 'required',
                'email' => 'required|valid_email',
                'plan' => 'required',
                'password' => 'required',
                'confirm_password' => 'required|matches[password]',
            ];

            if (!$this->validate($rules)) {
                $this->session->setFlashdata('error', 'Validation Error.');
                return view('admin/add_user', $data);
            } else {
                $mName = $this->request->getPost('name');
                $mEmail = $this->request->getPost('email');
                $mPlan = $this->request->getPost('plan');
                $mMobile = $this->request->getPost('mobile');
                $mPassword = $this->request->getPost('password');
                $mKey = $this->mGenerateRandomNumber();

                if ($mPassword == $this->request->getPost('confirm_password')) {
                    $mSecretPassword = base64_encode(utf8_encode($mPassword));
                    $userExists = $this->usersModel->checkUser($mEmail);
                    if (!$userExists) {
                        $data = [
                            'user_key' => $mKey,
                            'user_email' => $mEmail,
                            'user_name' => $mName,
                            'user_mobile' => $mMobile,
                            'user_plan' => $mPlan,
                            'user_password' => $mSecretPassword,
                            'user_status' => 1,
                            'user_payment_status' => 1,
                            'user_date_added' => date('Y-m-d H:i:s'),
                            'user_date_updated' => date('Y-m-d H:i:s')
                        ];
                        $mInsert = $this->usersModel->addUser($data);
                        if ($mInsert) {
                            $this->session->setFlashdata('success', $mName . ' registered successfully.');
                            return redirect()->to('admin/users');
                        } else {
                            $this->session->setFlashdata('error', 'Something went wrong, Please try again.');
                            return view('admin/add_user', $data);
                        }
                    } else {
                        $this->session->setFlashdata('error', 'This email has been already taken.');
                        return view('admin/add_user', $data);
                    }
                } else {
                    $this->session->setFlashdata('error', 'The Password and Confirm password doesnt match !!');
                    return view('admin/add_user', $data);
                }
            }
        } else {
            $this->session->setFlashdata('error', 'Something went wrong.');
            return view('admin/add_user', $data);
        }
    }

    public function actionEnable($param = null)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['navbar'] = "users";
            if ($param) {
                $getData = $this->usersModel->getParentByKey($param);
                if (!empty($getData)) {
                    $data = [
                        'user_status' => 1,
                        'user_payment_status' => 1,
                    ];
                    $result = $this->usersModel->updateParentByKey($param, $data);
                    if ($result == TRUE) {
                        $this->session->setFlashdata('success', $getData['user_name'] . ' Enabled');
                        return redirect()->to('admin/users');
                    } else {
                        $this->session->setFlashdata('error', 'Failed. Something went wrong.');
                        return redirect()->to('admin/users');
                    }
                } else {
                    $this->session->setFlashdata('error', 'Record not found.');
                    return redirect()->to('admin/users');
                }
            } else {
                $this->session->setFlashdata('error', 'Something went wrong.');
                return redirect()->to('admin/users');
            }
        } else {
            return view('admin/signin');
        }
    }
    public function actionDisable($param = null)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['navbar'] = "users";
            if ($param) {
                $getData = $this->usersModel->getParentByKey($param);
                if (!empty($getData)) {
                    $data = [
                        'user_status' => 0,
                        'user_payment_status' => 0,
                    ];
                    $result = $this->usersModel->updateParentByKey($param, $data);
                    if ($result == TRUE) {
                        $this->session->setFlashdata('success', $getData['user_name'] . ' Disabled.');
                        return redirect()->to('admin/users');
                    } else {
                        $this->session->setFlashdata('error', 'Failed. Something went wrong.');
                        return redirect()->to('admin/users');
                    }
                } else {
                    $this->session->setFlashdata('error', 'Record not found.');
                    return redirect()->to('admin/users');
                }
            } else {
                $this->session->setFlashdata('error', 'Something went wrong.');
                return redirect()->to('admin/users');
            }
        } else {
            return view('admin/signin');
        }
    }

    public function actionExtend($param)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['navbar'] = "users";
            if ($param) {
                $data['record'] = $this->usersModel->getParentByKey($param);
                return view('admin/extend_user_subscription', $data);
            } else {
                $this->session->setFlashdata('error', 'Something went wrong.');
                return redirect()->to('admin/users/extend');
            }
        } else {
            return view('admin/signin');
        }
    }
    
   public function updateExtend($param)
{
    $mAdminId = $this->session->get('login_admin_id');
    if (!$mAdminId) {
        return view('admin/signin');
    }

    if (!$param) {
        $this->session->setFlashdata('error', 'Invalid parameter.');
        return redirect()->to('admin/users/extend');
    }

    $getData = $this->usersModel->getParentByKey($param);
    if (empty($getData)) {
        $this->session->setFlashdata('error', 'Record not found.');
        return redirect()->to('admin/users/extend');
    }

    $extendDate = $this->request->getPost('extend');
    if (empty($extendDate)) {
        $this->session->setFlashdata('error', 'Extend date is required.');
        return redirect()->to('admin/users/extend');
    }

    $data = [
        'user_date_updated' => $extendDate,
    ];

    try {
        $result = $this->usersModel->updateParentByKey($param, $data);
        if ($result) {
            $this->session->setFlashdata('success', $getData['user_name'] . ' Extended Successfully.');
        } else {
            $this->session->setFlashdata('error', 'Failed to update. No changes were made.');
        }
    } catch (\Exception $e) {
        log_message('error', 'Update failed: ' . $e->getMessage());
        $this->session->setFlashdata('error', 'An error occurred while updating.');
    }

    return redirect()->to('admin/users/extend');
}

    public function actionDelete($param = null)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['navbar'] = "users";
            if ($param) {
                $getData = $this->usersModel->getParentByKey($param);
                if (!empty($getData)) {
                    $deleteData = $this->usersModel->deleteParentByKey($param);
                    if ($deleteData == TRUE) {
                        $this->session->setFlashdata('success', $getData['user_name'] . ' Deleted.');
                        return redirect()->to('admin/users');
                    } else {
                        $this->session->setFlashdata('error', 'Failed, Something went wrong.');
                        return redirect()->to('admin/users');
                    }
                } else {
                    $this->session->setFlashdata('error', 'Record not found.');
                    return redirect()->to('admin/users');
                }
            } else {
                $this->session->setFlashdata('error', 'Something went wrong.');
                return redirect()->to('admin/users');
            }
        } else {
            return view('admin/signin');
        }
    }

    private function mGenerateRandomNumber(): string
    {
        $key = '';
        $keys = array_merge(range('a', 'z'), range('A', 'Z'), range(0, 9));
        for ($i = 0; $i < 25; $i++) {
            $key .= $keys[array_rand($keys)];
        }
        return $key;
    }
}