<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\CategoryModel;

class Tags extends BaseController
{
    protected $categoryModel;
    protected $session;
    protected $validation;

    public function __construct()
    {
        helper(['form']); 
        $this->categoryModel = new CategoryModel();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();
    }

    public function index()
    {
        $data['sidebar'] = "tags";
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['tags'] = $this->categoryModel->getAllParent();
            return view('admin/tags', $data);
        } else {
            return view('admin/signin', $data);
        }
    }

    public function addTag()
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['sidebar'] = "tags";
            return view('admin/add_tag', $data);
        } else {
            return view('admin/signin');
        }
    }

    public function actionAddTag()
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['sidebar'] = "tags";
            if ($this->request->getMethod() === 'POST') {
                $rules = [
                    'category' => 'required'
                ];

                if (!$this->validate($rules)) {
                    return view('admin/add_tag', [
                        'sidebar' => 'tags',
                        'validation' => $this->validator
                    ]);
                }

                $mCategory = $this->request->getPost('category');
                $mKey = $this->mGenerateRandomNumber();
                $check = $this->categoryModel->checkParent($mCategory);
                if (empty($check)) {
                    $data = [
                        'category' => $mCategory,
                        'category_key' => $mKey,
                        'category_date_added' => date('Y-m-d H:i:s'),
                        'category_date_updated' => date('Y-m-d H:i:s')
                    ];
                    $result = $this->categoryModel->addParent($data);
                    if ($result) {
                        return redirect()->to('admin/tags')->with('success', 'Tag added.');
                    } else {
                        return view('admin/add_tag', [
                            'sidebar' => 'tags',
                            'error' => 'Failed. Something went wrong.'
                        ]);
                    }
                } else {
                    return redirect()->to('admin/tags')->with('error', 'Tag already exists.');
                }
            } else {
                return view('admin/add_tag', [
                    'sidebar' => 'tags',
                    'error' => 'Something went wrong.'
                ]);
            }
        } else {
            return view('admin/signin');
        }
    }

    public function actionEditTag($param = null)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['sidebar'] = "tags";
            if ($param) {
                $getCategory = $this->categoryModel->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data['tag'] = $getCategory;
                    return view('admin/edit_tag', $data);
                } else {
                    return redirect()->to('admin/tags')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/tags')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/signin');
        }
    }

    public function actionEnable($param = null)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            if ($param) {
                $getCategory = $this->categoryModel->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data = [
                        'category_status' => 1,
                    ];
                    $result = $this->categoryModel->updateParentByKey($param, $data);
                    if ($result) {
                        return redirect()->to('admin/tags')->with('success', 'Tag updated.');
                    } else {
                        return redirect()->to('admin/tags/actionEditTag/' . $param)->with('error', 'Failed. Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/tags')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/tags')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/signin');
        }
    }

    public function actionDisable($param = null)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            if ($param) {
                $getCategory = $this->categoryModel->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data = [
                        'category_status' => 0,
                    ];
                    $result = $this->categoryModel->updateParentByKey($param, $data);
                    if ($result) {
                        return redirect()->to('admin/tags')->with('success', 'Tag updated.');
                    } else {
                        return redirect()->to('admin/tags/actionEditTag/' . $param)->with('error', 'Failed. Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/tags')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/tags')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/signin');
        }
    }

    public function actionUpdateTag($param = null)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            if ($param) {
                $getCategory = $this->categoryModel->getParentByKey($param);
                if (!empty($getCategory)) {
                    if ($this->request->getMethod() === 'POST') {
                        $rules = [
                            'category' => 'required'
                        ];

                        if (!$this->validate($rules)) {
                            return redirect()->to('admin/tags/actionEditTag/' . $param)->with('error', 'Validation Error.');
                        }

                        $mCategory = $this->request->getPost('category');
                        $data = [
                            'category' => $mCategory,
                            'category_date_updated' => date('Y-m-d H:i:s')
                        ];

                        $result = $this->categoryModel->updateParentByKey($param, $data);
                        if ($result) {
                            return redirect()->to('admin/tags')->with('success', 'Tag updated.');
                        } else {
                            return redirect()->to('admin/tags/actionEditTag/' . $param)->with('error', 'Failed. Something went wrong.');
                        }
                    } else {
                        return redirect()->to('admin/tags/actionEditTag/' . $param)->with('error', 'Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/tags')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/tags')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/signin');
        }
    }

    public function actionDeleteTag($param)
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            if ($param) {
                $getCategory = $this->categoryModel->getParentByKey($param);
                if (!empty($getCategory)) {
                    $deleteCategory = $this->categoryModel->deleteParentByKey($param);
                    if ($deleteCategory) {
                        return redirect()->to('admin/tags')->with('success', 'Tag deleted.');
                    } else {
                        return redirect()->to('admin/tags')->with('error', 'Failed, Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/tags')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/tags')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/signin');
        }
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    public function uploadMultipleFiles($fileName)
    {
        if (!empty($fileName['name'])) {
            $uploadData = [];
            $filesCount = count($_FILES['files']['name']);
            for ($i = 0; $i < $filesCount; $i++) {
                $file = $this->request->getFile('files' . $i);
                if ($file->isValid() && !$file->hasMoved()) {
                    $newName = $file->getRandomName();
                    $file->move(FCPATH . 'uploads/categories', $newName);
                    $uploadData[] = ['file_name' => $newName];
                }
            }
            return json_encode($uploadData);
        }
        return '';
    }
}