<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class Sections extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $models = [];

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();

        $this->models = [
            'admin' => new \App\Models\AdminModel(),
            'category' => new \App\Models\CategoryModel(),
            'section' => new \App\Models\SectionModel(),
            'bareact' => new \App\Models\BareactModel(),
            // 'subcategory' => new \App\Models\SubcategoryModel(),
        ];

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function index()
    {
        $data['sidebar'] = "sections";
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['sections'] = $this->models['section']->getAllParent();
            return view('admin/sections', $data);
        } else {
            return view('admin/signin', $data);
        }
    }

    public function addSection()
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['sidebar'] = "sections";
            $data['bareacts'] = $this->models['bareact']->getAllParent();
            return view('admin/add_section', $data);
        } else {
            return view('admin/login');
        }
    }

    public function actionAddSection()
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "sections";
            if ($this->request->getMethod() === 'POST') {
                $rules = [
                    'bareact' => 'required',
                    'title' => 'required',
                    'particular' => 'required',
                ];

                if (!$this->validate($rules)) {
                    return redirect()->to('admin/sections/addSection')->with('error', 'Validation Error.')->withInput();
                }

                $mBa = $this->request->getPost('bareact');
                $mTitle = $this->request->getPost('title');
                $mPar = $this->request->getPost('particular');
                $mSubTitle = $this->request->getPost('subtitle');
                $mSubPar = $this->request->getPost('subparticular');
                $mData = $this->request->getPost('data');
                $mKey = $this->mGenerateRandomNumber();

                $data = [
                    'sec_key' => $mKey,
                    'sec_ba_key' => $mBa,
                    'sec_title' => $mTitle,
                    'sec_particular' => $mPar,
                    'sec_subtitle' => $mSubTitle,
                    'sec_subparticular' => $mSubPar,
                    'sec_data' => json_encode($mData),
                    'sec_date_added' => date('Y-m-d H:i:s'),
                    'sec_date_updated' => date('Y-m-d H:i:s')
                ];

                $result = $this->models['section']->addParent($data);
                if ($result) {
                    return redirect()->to('admin/sections')->with('success', 'Section added.');
                } else {
                    return redirect()->to('admin/sections/addSection')->with('error', 'Failed. Something went wrong.');
                }
            } else {
                return redirect()->to('admin/sections/addSection')->with('error', 'Something went wrong.');
            }
        } else {
            return redirect()->to('admin/home');
        }
    }

    public function actionEditBareact($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "sections";
            if ($param) {
                $getCategory = $this->models['section']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data['bareacts'] = $this->models['bareact']->getAllParent();
                    $data['parent'] = $getCategory;
                    return view('admin/edit_section', $data);
                } else {
                    return redirect()->to('admin/sections')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/sections')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionEnable($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "sections";
            if ($param) {
                $getCategory = $this->models['section']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data = [
                        'sec_status' => 1,
                    ];
                    $result = $this->models['section']->updateParentByKey($param, $data);
                    if ($result) {
                        return redirect()->to('admin/sections')->with('success', 'Section enabled.');
                    } else {
                        return redirect()->to('admin/sections')->with('error', 'Failed. Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/sections')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/sections')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionDisable($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "sections";
            if ($param) {
                $getCategory = $this->models['section']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data = [
                        'sec_status' => 0,
                    ];
                    $result = $this->models['section']->updateParentByKey($param, $data);
                    if ($result) {
                        return redirect()->to('admin/sections')->with('success', 'Section disabled.');
                    } else {
                        return redirect()->to('admin/sections')->with('error', 'Failed. Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/sections')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/sections')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionUpdateSection($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "sections";
            if ($param) {
                $getCategory = $this->models['section']->getParentByKey($param);
                if (!empty($getCategory)) {
                    if ($this->request->getMethod() === 'POST') {
                        $rules = [
                            'bareact' => 'required',
                            'title' => 'required',
                            'particular' => 'required',
                        ];

                        if (!$this->validate($rules)) {
                            return redirect()->to('admin/sections/actionEditBareact/' . $param)->with('error', 'Validation Error.');
                        }

                        $mBa = $this->request->getPost('bareact');
                        $mTitle = $this->request->getPost('title');
                        $mPar = $this->request->getPost('particular');
                        $mSubTitle = $this->request->getPost('subtitle');
                        $mSubPar = $this->request->getPost('subparticular');
                        $mData = $this->request->getPost('data');

                        $data = [
                            'sec_ba_key' => $mBa,
                            'sec_title' => $mTitle,
                            'sec_particular' => $mPar,
                            'sec_subtitle' => $mSubTitle,
                            'sec_subparticular' => $mSubPar,
                            'sec_data' => json_encode($mData),
                            'sec_date_updated' => date('Y-m-d H:i:s')
                        ];

                        $result = $this->models['section']->updateParentByKey($param, $data);
                        if ($result) {
                            return redirect()->to('admin/sections/actionEditBareact/' . $param)->with('success', 'Section updated.');
                        } else {
                            return redirect()->to('admin/sections/actionEditBareact/' . $param)->with('error', 'Failed. Something went wrong.');
                        }
                    } else {
                        return redirect()->to('admin/sections/actionEditBareact/' . $param)->with('error', 'Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/sections')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/sections')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionDeleteSection($param)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "sections";
            if ($param) {
                $getCategory = $this->models['section']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $deleteCategory = $this->models['section']->deleteParentByKey($param);
                    if ($deleteCategory) {
                        return redirect()->to('admin/sections')->with('success', 'Section deleted.');
                    } else {
                        return redirect()->to('admin/sections')->with('error', 'Failed, Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/sections')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/sections')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function getSubcatByCat()
    {
        $categoryKey = $this->request->getPost('value');
        $subs = $this->models['subcategory']->getSubCatByCat($categoryKey);
        if (!empty($subs)) {
            $result = '<option disabled="" selected="">Select Sub-Category</option>';
            foreach ($subs as $sub) {
                $result .= "<option value='" . $sub['subcategory_key'] . "'>" . $sub['subcategory'] . "</option>" . PHP_EOL;
            }
            return $this->response->setJSON(['status' => 'success', 'data' => $result]);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'No Sub Categories']);
        }
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    private function articleFileUpload($mId, $mFile)
    {
        if ($mFile->isValid() && !$mFile->hasMoved()) {
            $newName = $mFile->getRandomName();
            $mFile->move(FCPATH . 'uploads/sections', $newName);
            return $newName;
        }
        return '';
    }
}