<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class Lawyers extends BaseController
{
    protected $lawyers_model;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->lawyers_model = model('LawyersModel');
        $this->session = \Config\Services::session();
        helper(['form', 'url', 'date']);
        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function index()
    {
        $data['sidebar'] = "lawyers";
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['lawyers'] = $this->lawyers_model->getAllParentBySortingForAdmin();
            return view('admin/lawyers', $data);
        } else {
            return view('admin/signin', $data);
        }
    }

    public function actionEnable($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "lawyers";
            if ($param) {
                $getCategory = $this->lawyers_model->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data = [
                        'Status' => 1,
                    ];
                    $result = $this->lawyers_model->updateParentByKey($param, $data);
                    if ($result) {
                        return redirect()->to('admin/lawyers')->with('success', 'Lawyer enabled.');
                    } else {
                        return redirect()->to('admin/lawyers')->with('error', 'Failed. Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/lawyers')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/lawyers')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionDisable($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "lawyers";
            if ($param) {
                $getCategory = $this->lawyers_model->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data = [
                        'Status' => 0,
                    ];
                    $result = $this->lawyers_model->updateParentByKey($param, $data);
                    if ($result) {
                        return redirect()->to('admin/lawyers')->with('success', 'Lawyer disabled.');
                    } else {
                        return redirect()->to('admin/lawyers')->with('error', 'Failed. Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/lawyers')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/lawyers')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    public function articleFileUpload($mId, $mFile)
    {
        $validationRule = [
            $mId => [
                'label' => 'Article File',
                'rules' => [
                    'uploaded[' . $mId . ']',
                    'mime_in[' . $mId . ',image/jpg,image/jpeg,image/gif,image/png,application/zip,application/pdf,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/vnd.ms-powerpoint,application/vnd.openxmlformats-officedocument.presentationml.presentation,application/vnd.oasis.opendocument.text,application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,audio/mpeg,audio/x-m4a,audio/ogg,audio/wav,video/mp4,video/x-m4v,video/quicktime,video/x-ms-wmv,video/mpeg]',
                    'max_size[' . $mId . ',10240]',
                ],
            ],
        ];

        if (! $this->validate($validationRule)) {
            return '';
        }

        $img = $this->request->getFile($mId);

        if (! $img->hasMoved()) {
            $filepath = FCPATH . 'uploads/articles/';
            $filename = $img->store('articles/', $img->getRandomName());
            return $filename;
        }

        return '';
    }
}