<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AdminModel;
use App\Models\CategoryModel;
use App\Models\ArticleModel;

class Home extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $session;
    protected $adminModel;
    protected $categoryModel;
    protected $articleModel;

    public function initController(\CodeIgniter\HTTP\RequestInterface $request, \CodeIgniter\HTTP\ResponseInterface $response, \Psr\Log\LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->session = \Config\Services::session();
        $this->adminModel = new AdminModel();
        $this->categoryModel = new CategoryModel();
        $this->articleModel = new ArticleModel();

        $this->db = \Config\Database::connect();
        $this->validation = \Config\Services::validation();
        
        date_default_timezone_set("Asia/Kolkata");
    }

    public function index()
    {
        $data['sidebar'] = "dashboard";
        $mAdminId = $this->session->get('login_admin_id');

        if ($mAdminId) {
            $data['navbar'] = "home";
            $data['articles'] = $this->articleModel->getAllParent();
            $data['tags'] = $this->categoryModel->getAllParent();
            return view('admin/index', $data);
        } else {
            return view('admin/signin', $data);
        }
    }

    public function authenticate()
    {
        if ($this->request->getMethod() === 'POST') {
            $rules = [
                'email' => 'required|valid_email',
                'password' => 'required|min_length[6]|max_length[15]'
            ];

            if (!$this->validate($rules)) {
                return redirect()->back()->with('error', $this->validator->getErrors())->withInput();
            }

            $mEmail = $this->request->getPost('email');
            $mPassword = $this->request->getPost('password');
            $mSecretPassword = base64_encode($mPassword);
            log_message('debug', 'mEmail value: ' . (($mPassword ?? 'not set')));

            $mIsAuthenticated = $this->adminModel->authenticateAdminUser($mEmail, $mSecretPassword);

            if ($mIsAuthenticated) {
                $user = $this->adminModel->getUserByEmail($mEmail);
                if ($user['admin_status'] == 0) {
                    $this->session->destroy();
                    return redirect()->back()->with('error', 'Admin User blocked.');
                } else {
                    $mAdminName = $this->session->get('login_admin_name');
                    return redirect()->to('admin/home')->with('success', 'Welcome ' . $mAdminName);
                }
            } else {
                return redirect()->back()->with('error', 'User not found.')->withInput();
            }
        }

        return redirect()->back()->with('error', 'Something went wrong.');
    }

    public function logout()
    {
        $this->session->destroy();
        return redirect()->to('admin/home');
    }
}