<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class District extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $models = [];

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();

        $this->models = [
            'admin' => new \App\Models\AdminModel(),
            'district' => new \App\Models\DistrictModel(),
            // 'subcategory' => new \App\Models\SubcategoryModel(),
        ];

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function index()
    {
        $data['sidebar'] = "district";
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['district'] = $this->models['district']->getAllParent();
            return view('admin/district', $data);
        } else {
            return view('admin/signin', $data);
        }
    }

    public function add()
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['sidebar'] = "district";
            $data['district'] = $this->models['district']->getAllParent();
            return view('admin/add_district', $data);
        } else {
            return view('admin/login');
        }
    }

    public function actionAdd()
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "district";
            if ($this->request->getMethod() === 'POST') {
                $rules = [
                    'title' => 'required',
                ];

                if (!$this->validate($rules)) {
                    return redirect()->to('admin/district/add')->with('error', 'Validation Error.')->withInput();
                }

                $mTitle = $this->request->getPost('title');
                $pic = $this->request->getFile('image');

                $mToUploadProductPic = $this->articleFileUpload('image', $pic);

                $mKey = $this->mGenerateRandomNumber();
                $data = [
                    'district_key' => $mKey,
                    'district_name' => $mTitle,
                    'district_image' => $mToUploadProductPic,
                    'district_date_added' => date('Y-m-d H:i:s'),
                ];
                $result = $this->models['district']->addParent($data);
                if ($result) {
                    return redirect()->to('admin/district')->with('success', 'District added.');
                } else {
                    return redirect()->to('admin/district/add')->with('error', 'Failed. Something went wrong.')->withInput();
                }
            } else {
                return redirect()->to('admin/district/add')->with('error', 'Something went wrong.');
            }
        } else {
            return redirect()->to('admin/home');
        }
    }

    public function actionEdit($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "district";
            $data['district'] = $this->models['district']->getAllParent();
            if ($param) {
                $getCategory = $this->models['district']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data['district'] = $getCategory;
                    return view('admin/edit_district', $data);
                } else {
                    return redirect()->to('admin/district')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/district')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionEnable($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "district";
            if ($param) {
                $getCategory = $this->models['district']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data = [
                        'district_status' => 1,
                    ];
                    $result = $this->models['district']->updateParentByKey($param, $data);
                    if ($result) {
                        return redirect()->to('admin/district')->with('success', 'District updated.');
                    } else {
                        return redirect()->to('admin/district')->with('error', 'Failed. Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/district')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/district')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionDisable($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "district";
            if ($param) {
                $getCategory = $this->models['district']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data = [
                        'district_status' => 0,
                    ];
                    $result = $this->models['district']->updateParentByKey($param, $data);
                    if ($result) {
                        return redirect()->to('admin/district')->with('success', 'District updated.');
                    } else {
                        return redirect()->to('admin/district')->with('error', 'Failed. Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/district')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/district')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionUpdate($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "district";
            if ($param) {
                $getCategory = $this->models['district']->getParentByKey($param);
                if (!empty($getCategory)) {
                    if ($this->request->getMethod() === 'POST') {
                        $rules = [
                            'title' => 'required',
                        ];

                        if (!$this->validate($rules)) {
                            return redirect()->to('admin/district/actionEdit/' . $param)->with('error', 'Validation Error.')->withInput();
                        }

                        $mTitle = $this->request->getPost('title');
                        $pic = $this->request->getFile('image');
                        $mToUploadProductPic = $this->articleFileUpload('image', $pic);
                        $changedImage = !empty($mToUploadProductPic) ? $mToUploadProductPic : $getCategory['district_image'];
                        
                        $data = [
                            'district_name' => $mTitle,
                            'district_image' => $changedImage,
                            'district_date_added' => date('Y-m-d H:i:s')
                        ];
                        $result = $this->models['district']->updateParentByKey($param, $data);
                        if ($result) {
                            return redirect()->to('admin/district/actionEdit/' . $param)->with('success', 'Court updated.');
                        } else {
                            return redirect()->to('admin/district/actionEdit/' . $param)->with('error', 'Failed. Something went wrong.');
                        }
                    } else {
                        return redirect()->to('admin/district/actionEdit/' . $param)->with('error', 'Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/district')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/district')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionDelete($param)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "district";
            if ($param) {
                $getCategory = $this->models['district']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $deleteCategory = $this->models['district']->deleteParentByKey($param);
                    if ($deleteCategory) {
                        return redirect()->to('admin/district')->with('success', 'District deleted.');
                    } else {
                        return redirect()->to('admin/district')->with('error', 'Failed, Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/district')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/district')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function getSubcatByCat()
    {
        $categoryKey = $this->request->getPost('value');
        $subs = $this->models['subcategory']->getSubCatByCat($categoryKey);
        if (!empty($subs)) {
            $result = '<option disabled="" selected="">Select Sub-Category</option>';
            foreach ($subs as $sub) {
                $result .= "<option value='{$sub['subcategory_key']}'>{$sub['subcategory']}</option>" . PHP_EOL;
            }
            return $this->response->setJSON(['html' => $result]);
        } else {
            return $this->response->setJSON(['html' => "<option>No Sub Categories</option>"]);
        }
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    private function articleFileUpload($mId, $file)
{
    if ($file !== null && $file->isValid() && !$file->hasMoved()) {
        $newName = $file->getRandomName();
        $file->move(FCPATH . 'uploads/district', $newName);
        return $newName;
    }
    return '';
}
}