<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class Courts extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $models = [];

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();
        $this->upload = \Config\Services::upload();

        $this->models = [
            'admin' => new \App\Models\AdminModel(),
            'court' => new \App\Models\CourtModel(),
            // 'subcategory' => new \App\Models\SubcategoryModel(),
        ];

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function index()
    {
        $data['sidebar'] = "courts";
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['courts'] = $this->models['court']->getAllParent();
            return view('admin/courts', $data);
        } else {
            return view('admin/signin', $data);
        }
    }

    public function add()
    {
        $mAdminId = $this->session->get('login_admin_id');
        if ($mAdminId) {
            $data['sidebar'] = "courts";
            $data['courts'] = $this->models['court']->getAllParent();
            return view('admin/add_court', $data);
        } else {
            return view('admin/login');
        }
    }

    public function actionAdd()
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "courts";
            if ($this->request->getMethod() === 'POST') {
                $rules = [
                    'title' => 'required',
                ];

                if (!$this->validate($rules)) {
                    return redirect()->to('admin/courts/add')->with('error', 'Validation Error.')->withInput();
                }

                $mTitle = $this->request->getPost('title');
                $pic = $this->request->getPost('image');
                $mToUploadProductPic = $this->articleFileUpload('image', $pic);

                $mKey = $this->mGenerateRandomNumber();
                $data = [
                    'court_key' => $mKey,
                    'court_name' => $mTitle,
                    'court_image' => $mToUploadProductPic,
                    'court_date_added' => date('Y-m-d H:i:s'),
                    'court_date_updated' => date('Y-m-d H:i:s')
                ];
                $result = $this->models['court']->addParent($data);
                if ($result) {
                    return redirect()->to('admin/courts')->with('success', 'Court added.');
                } else {
                    return redirect()->to('admin/courts/add')->with('error', 'Failed. Something went wrong.');
                }
            } else {
                return redirect()->to('admin/courts/add')->with('error', 'Something went wrong.');
            }
        } else {
            return redirect()->to('admin/home');
        }
    }

    public function actionEdit($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "courts";
            $data['courts'] = $this->models['court']->getAllParent();
            if ($param) {
                $getCategory = $this->models['court']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data['court'] = $getCategory;
                    return view('admin/edit_court', $data);
                } else {
                    return redirect()->to('admin/courts')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/courts')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionEnable($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "courts";
            if ($param) {
                $getCategory = $this->models['court']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data = [
                        'court_status' => 1,
                    ];
                    $result = $this->models['court']->updateParentByKey($param, $data);
                    if ($result) {
                        return redirect()->to('admin/courts')->with('success', 'Courts updated.');
                    } else {
                        return redirect()->to('admin/courts')->with('error', 'Failed. Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/courts')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/courts')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionDisable($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "courts";
            if ($param) {
                $getCategory = $this->models['court']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data = [
                        'court_status' => 0,
                    ];
                    $result = $this->models['court']->updateParentByKey($param, $data);
                    if ($result) {
                        return redirect()->to('admin/courts')->with('success', 'Court updated.');
                    } else {
                        return redirect()->to('admin/courts')->with('error', 'Failed. Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/courts')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/courts')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionUpdate($param = null)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "courts";
            if ($param) {
                $getCategory = $this->models['court']->getParentByKey($param);
                if (!empty($getCategory)) {
                    if ($this->request->getMethod() === 'POST') {
                        $rules = [
                            'title' => 'required',
                        ];

                        if (!$this->validate($rules)) {
                            return redirect()->to('admin/courts/actionEdit/' . $param)->with('error', 'Validation Error.')->withInput();
                        }

                        $mTitle = $this->request->getPost('title');
                        $pic = $this->request->getPost('image');
                        $mToUploadProductPic = $this->articleFileUpload('image', $pic);
                        $changedImage = !empty($mToUploadProductPic) ? $mToUploadProductPic : $getCategory['court_image'];
                        
                        $data = [
                            'court_name' => $mTitle,
                            'court_image' => $changedImage,
                            'court_date_updated' => date('Y-m-d H:i:s')
                        ];
                        $result = $this->models['court']->updateParentByKey($param, $data);
                        if ($result) {
                            return redirect()->to('admin/courts/actionEdit/' . $param)->with('success', 'Court updated.');
                        } else {
                            return redirect()->to('admin/courts/actionEdit/' . $param)->with('error', 'Failed. Something went wrong.');
                        }
                    } else {
                        return redirect()->to('admin/courts/actionEdit/' . $param)->with('error', 'Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/courts')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/courts')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionDelete($param)
    {
        $mUserId = $this->session->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "courts";
            if ($param) {
                $getCategory = $this->models['court']->getParentByKey($param);
                if (!empty($getCategory)) {
                    $deleteCategory = $this->models['court']->deleteParentByKey($param);
                    if ($deleteCategory) {
                        return redirect()->to('admin/courts')->with('success', 'Court deleted.');
                    } else {
                        return redirect()->to('admin/courts')->with('error', 'Failed, Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/courts')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/courts')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function getSubcatByCat()
    {
        $categoryKey = $this->request->getPost('value');
        $subs = $this->models['subcategory']->getSubCatByCat($categoryKey);
        if (!empty($subs)) {
            $result = '<option disabled="" selected="">Select Sub-Category</option>';
            foreach ($subs as $sub) {
                $result .= "<option value='" . $sub['subcategory_key'] . "'>" . $sub['subcategory'] . "</option>" . PHP_EOL;
            }
            return $this->response->setJSON(['success' => true, 'data' => $result]);
        } else {
            return $this->response->setJSON(['success' => false, 'data' => "<option>No Sub Categories</option>"]);
        }
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    private function articleFileUpload($mId, $mFile)
    {
        $validationRule = [
            $mId => [
                'label' => 'Image File',
                'rules' => [
                    'uploaded[' . $mId . ']',
                    'is_image[' . $mId . ']',
                    'mime_in[' . $mId . ',image/jpg,image/jpeg,image/gif,image/png,image/webp]',
                    'max_size[' . $mId . ',100]',
                    'max_dims[' . $mId . ',1024,768]',
                ],
            ],
        ];

        if (! $this->validate($validationRule)) {
            return '';
        }

        $img = $this->request->getFile($mId);

        if (! $img->hasMoved()) {
            $filepath = FCPATH . 'uploads/courts/';
            $filename = $img->store('courts/', $img->getRandomName());
            return $filename;
        }

        return '';
    }
}