<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AdminModel;
use App\Models\AuthorModel;

class Authors extends BaseController
{
    protected $adminModel;
    protected $authorModel;

    public function __construct()
    {
        $this->adminModel = new AdminModel();
        $this->authorModel = new AuthorModel();
    }

    public function index()
    {
        $data['sidebar'] = "authors";
        $mAdminId = session()->get('login_admin_id');
        if ($mAdminId) {
            $data['authors'] = $this->authorModel->getAllParent();
            return view('admin/authors', $data);
        } else {
            return view('admin/signin', $data);
        }
    }

    public function add()
    {
        $mAdminId = session()->get('login_admin_id');
        if ($mAdminId) {
            $data['sidebar'] = "authors";
            return view('admin/add_author', $data);
        } else {
            return view('admin/login');
        }
    }

    public function actionAdd()
    {
        $mUserId = session()->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "authors";
            if ($this->request->getMethod() === 'POST') {
                $rules = [
                    'name' => 'required|trim'
                ];

                if (!$this->validate($rules)) {
                    return redirect()->to('admin/authors/add')->with('error', 'Validation Error.')->withInput();
                }

                $mName = $this->request->getPost('name');
                $mKey = $this->mGenerateRandomNumber();
                $data = [
                    'author_key' => $mKey,
                    'author_name' => $mName,
                    'author_date_added' => date('Y-m-d H:i:s'),
                    'author_date_updated' => date('Y-m-d H:i:s')
                ];

                $result = $this->authorModel->addParent($data);
                if ($result) {
                    return redirect()->to('admin/authors')->with('success', 'Author added.');
                } else {
                    return redirect()->to('admin/authors/add')->with('error', 'Failed. Something went wrong.');
                }
            } else {
                return redirect()->to('admin/authors/add')->with('error', 'Something went wrong.');
            }
        } else {
            return redirect()->to('admin/home');
        }
    }

    public function actionEdit($param = null)
    {
        $mUserId = session()->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "seminars";
            if ($param) {
                $getCategory = $this->authorModel->getParentByKey($param);
                if (!empty($getCategory)) {
                    $data['author'] = $getCategory;
                    return view('admin/edit_author', $data);
                } else {
                    return redirect()->to('admin/authors')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/authors')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionEnable($param = null)
{
    $mUserId = session()->get('login_admin_id');
    if (!$mUserId) {
        return redirect()->to('admin/login');
    }

    if (!$param) {
        return redirect()->to('admin/authors')->with('error', 'Invalid author key.');
    }

    $author = $this->authorModel->getParentByKey($param);
    if (empty($author)) {
        return redirect()->to('admin/authors')->with('error', 'Author not found.');
    }

    // Check if the author is already enabled
    if ($author['author_status'] == 1) {
        return redirect()->to('admin/authors')->with('info', 'Author is already enabled.');
    }

    $data = [
        'author_status' => 1,
        'author_date_updated' => date('Y-m-d H:i:s')
    ];

    try {
        $result = $this->authorModel->updateParentByKey($param, $data);
        if ($result) {
            return redirect()->to('admin/authors')->with('success', 'Author enabled successfully.');
        } else {
            return redirect()->to('admin/authors')->with('error', 'Failed to enable author. No changes were made.');
        }
    } catch (\Exception $e) {
        log_message('error', 'Author enable failed: ' . $e->getMessage());
        return redirect()->to('admin/authors')->with('error', 'An error occurred while enabling the author.');
    }
}

    public function actionDisable($param = null)
    {
        $mUserId = session()->get('login_admin_id');
        if (!$mUserId) {
            return redirect()->to('admin/login');
        }
    
        if (!$param) {
            return redirect()->to('admin/authors')->with('error', 'Invalid author key.');
        }
    
        $author = $this->authorModel->getParentByKey($param);
        if (empty($author)) {
            return redirect()->to('admin/authors')->with('error', 'Author not found.');
        }
    
        // Check if the author is already disabled
        if ($author['author_status'] == 0) {
            return redirect()->to('admin/authors')->with('info', 'Author is already disabled.');
        }
    
        $data = [
            'author_status' => 0,
            'author_date_updated' => date('Y-m-d H:i:s')
        ];
    
        try {
            $result = $this->authorModel->updateParentByKey($param, $data);
            if ($result) {
                return redirect()->to('admin/authors')->with('success', 'Author disabled successfully.');
            } else {
                return redirect()->to('admin/authors')->with('error', 'Failed to disable author. No changes were made.');
            }
        } catch (\Exception $e) {
            log_message('error', 'Author disable failed: ' . $e->getMessage());
            return redirect()->to('admin/authors')->with('error', 'An error occurred while disabling the author.');
        }
    }
    public function actionUpdate($param = null)
    {
        $mUserId = session()->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "seminars";
            if ($param) {
                $getCategory = $this->authorModel->getParentByKey($param);
                if (!empty($getCategory)) {
                    if ($this->request->getMethod() === 'POST') {
                        $rules = [
                            'name' => 'required'
                        ];

                        if (!$this->validate($rules)) {
                            return redirect()->to('admin/authors/actionEdit/' . $param)->with('error', 'Validation Error.')->withInput();
                        }

                        $mName = $this->request->getPost('name');
                        $data = [
                            'author_name' => $mName,
                            'author_date_updated' => date('Y-m-d H:i:s')
                        ];
                        $result = $this->authorModel->updateParentByKey($param, $data);
                        if ($result) {
                            return redirect()->to('admin/authors/actionEdit/' . $param)->with('success', 'Author updated.');
                        } else {
                            return redirect()->to('admin/authors/actionEdit/' . $param)->with('error', 'Failed. Something went wrong.');
                        }
                    } else {
                        return redirect()->to('admin/authors/actionEdit/' . $param)->with('error', 'Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/authors')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/authors')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function actionDelete($param)
    {
        $mUserId = session()->get('login_admin_id');
        if ($mUserId) {
            $data['active'] = "seminars";
            if ($param) {
                $getCategory = $this->authorModel->getParentByKey($param);
                if (!empty($getCategory)) {
                    $deleteCategory = $this->authorModel->deleteParentByKey($param);
                    if ($deleteCategory) {
                        return redirect()->to('admin/authors')->with('success', 'Seminar deleted.');
                    } else {
                        return redirect()->to('admin/authors')->with('error', 'Failed, Something went wrong.');
                    }
                } else {
                    return redirect()->to('admin/authors')->with('error', 'Record not found.');
                }
            } else {
                return redirect()->to('admin/authors')->with('error', 'Something went wrong.');
            }
        } else {
            return view('admin/login');
        }
    }

    public function getSubcatByCat()
    {
        $categoryKey = $this->request->getPost('value');
        $subs = $this->subcategoryModel->getSubCatByCat($categoryKey);
        if (!empty($subs)) {
            $result = '<option disabled="" selected="">Select Sub-Category</option>';
            foreach ($subs as $sub) {
                $result .= "<option value='{$sub['subcategory_key']}'>{$sub['subcategory']}</option>" . PHP_EOL;
            }
            return $this->response->setJSON(['html' => $result]);
        } else {
            return $this->response->setJSON(['html' => "<option>No Sub Categories</option>"]);
        }
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    public function articleFileUpload($mId, $mFile)
    {
        $validationRule = [
            $mId => [
                'label' => 'Image File',
                'rules' => [
                    'uploaded[' . $mId . ']',
                    'is_image[' . $mId . ']',
                    'mime_in[' . $mId . ',image/jpg,image/jpeg,image/gif,image/png,image/webp]',
                    'max_size[' . $mId . ',100]',
                    'max_dims[' . $mId . ',1024,768]',
                ],
            ],
        ];

        if (! $this->validate($validationRule)) {
            return $this->response->setJSON([
                'error' => $this->validator->getErrors()
            ]);
        }

        $img = $this->request->getFile($mId);

        if (! $img->hasMoved()) {
            $filepath = FCPATH . 'uploads/seminars/';
            $name = $img->getRandomName();
            $img->move($filepath, $name);
            return $name;
        } else {
            return '';
        }
    }
}