<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

// require APPPATH . 'Libraries/razorpay/config.php';
require APPPATH . 'Libraries\razorpay\razorpay-php\Razorpay.php';

define('RAZORPAY_KEY',getenv('RAZORPAY_KEY'));
define('RAZORPAY_SECRET_KEY',getenv('RAZORPAY_SECRET_KEY'));
define('RAZORPAY_CURRENCY', "INR");

use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;

class Users extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $models = ['usersModel'];

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();
        $this->upload = \Config\Services::upload();
        $this->email = \Config\Services::email();

        $this->usersModel = new \App\Models\UsersModel();

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function testMail()
    {
        $config = [
            'mailType' => 'html',
            'charset'  => 'utf-8',
            'priority' => '1'
        ];
        $this->email->initialize($config);
        $this->email->setFrom('nithin@dakshalegal.com', 'Daksha Legal');
        $this->email->setTo("akhilmunti@gmail.com");
        $this->email->setSubject('Approval Note for EOT: ');
        $message = "
<html>
<head>
</head>
<body>
<h3>Dear Akhil,</h3><br>
<p>Please click the below link to View & perform actions (viz. Approve/Reject/Keep on Hold) on the Approval Note for EOT.</p>
<h4>Thanking you,</h4>
</body>
</html>";
        $this->email->setMessage($message);
        $this->email->send();
    }

    public function index()
    {
        $mSessionKey = $this->session->get('session_key');
        if (!empty($mSessionKey)) {
            $data['navbar'] = "users";
            $data['users'] = $this->models['users']->getAllParent();
            return view('users', $data);
        } else {
            return view('login');
        }
    }

    public function edit($param = null)
    {
        $mSessionKey = $this->session->get('session_key');
        if (!empty($mSessionKey)) {
            if ($param) {
                $data['navbar'] = "users";
                $data['user'] = $this->models['users']->getParentByKey($param);
                return view('edit_user', $data);
            } else {
                $this->session->setFlashdata('error', 'Something went wrong, Please try again.');
                return redirect()->to('users');
            }
        } else {
            return view('login');
        }
    }

    public function auto($param = null)
    {
        return view('automatic', $data);
    }

    public function actionUpdate($param = null)
    {
        $mSessionKey = $this->session->get('session_key');
        if ($mSessionKey) {
            if ($param) {
                $data['navbar'] = "users";
                if ($this->request->getMethod() === 'post') {
                    $rules = [
                        'name' => 'required',
                        'email' => 'required|valid_email',
                    ];

                    if (!$this->validate($rules)) {
                        $this->session->setFlashdata('error', 'Validation Error.');
                        return redirect()->to('users/edit/' . $param)->withInput();
                    }

                    $user = $this->models['users']->getParentByKey($param);
                    $mName = $this->request->getPost('name');
                    $mEmail = $this->request->getPost('email');

                    if ($mEmail == $user['user_email']) {
                        $data = [
                            'user_email' => $mEmail,
                            'user_name' => $mName,
                        ];
                        $mInsert = $this->models['users']->updateParentByKey($param, $data);
                        if ($mInsert) {
                            $this->session->setFlashdata('success', $mName . ' updated.');
                            return redirect()->to('users/edit/' . $param);
                        } else {
                            $this->session->setFlashdata('error', 'Something went wrong, Please try again.');
                            return redirect()->to('users/edit/' . $param);
                        }
                    } else {
                        $userExists = $this->models['users']->checkUser($mEmail);
                        if (!$userExists) {
                            $data = [
                                'user_email' => $mEmail,
                                'user_name' => $mName,
                            ];
                            $mInsert = $this->models['users']->updateParentByKey($param, $data);
                            if ($mInsert) {
                                $this->session->setFlashdata('success', $mName . ' updated.');
                                return redirect()->to('users/edit/' . $param);
                            } else {
                                $this->session->setFlashdata('error', 'Something went wrong, Please try again.');
                                return redirect()->to('users/edit/' . $param);
                            }
                        } else {
                            $this->session->setFlashdata('error', 'This email has been already taken.');
                            return redirect()->to('users/edit/' . $param);
                        }
                    }
                } else {
                    $this->session->setFlashdata('error', 'Something went wrong.');
                    return redirect()->to('users/edit/' . $param);
                }
            } else {
                $this->session->setFlashdata('error', 'Something went wrong.');
                return redirect()->to('users');
            }
        } else {
            return redirect()->to('users');
        }
    }


    public function signup($param = null)
{
    $data['home'] = "users";
    if ($param) {
        $data['plan'] = $param;
    }
    return view('add_user', $data);
}

public function signin()
{
    $data['home'] = "users";
    return view('signin', $data);
}

public function actionSignin()
{
    $data['navbar'] = "";
    if ($this->request->getMethod() === 'POST') {
        $rules = [
            'email' => 'required|valid_email',
            'password' => 'required|min_length[6]|max_length[13]'
        ];

        if (!$this->validate($rules)) {
            $this->session->setFlashdata('error', 'Validation Error');
            return view('login', $data);
        }

        $mEmail = $this->request->getPost('email');
        $mPassword = $this->request->getPost('password');
        $mSecretPassword = base64_encode(utf8_encode($mPassword));
        
        $mRecord = $this->usersModel->getUserByEmail($mEmail);

        if ($mRecord['user_status'] == 0) {
            $this->session->setFlashdata('error', 'User disabled by the admin.');
            return redirect()->to('users/signin');
        } else if ($mRecord['user_payment_status'] == 0) {
            $api = new Api(RAZORPAY_KEY, RAZORPAY_SECRET_KEY);
            $mPaymentStatus = $mRecord['user_payment_status'];
            $mPlan = $mRecord['user_plan'];
            $mUserKey = $mRecord['user_key'];
            $mReceiptKey = $this->mGenerateRandomNumber();

            $prices = [1 => 1770, 2 => 4130, 3 => 7080, 4 => 1180, 5 => 3540];
            $packages = [
                1 => "JUNIOR ADVOCATES (BELOW 10 YEARS EXP)",
                2 => "SENIOR ADVOCATES (BELOW 10 YEARS EXP)",
                3 => "DONORS AND PROMOTORS",
                4 => "STUDENTS",
                5 => "GENERAL PUBLIC"
            ];

            $mPrice = ($prices[$mPlan] ?? 0) * 100;
            $mPackage = $packages[$mPlan] ?? "";

            $orderData = [
                'receipt' => $mReceiptKey,
                'amount' => $mPrice,
                'currency' => 'INR',
                'payment_capture' => 1
            ];

            $razorpayOrder = $api->order->create($orderData);
            $razorpayOrderId = $razorpayOrder['id'];
            $this->session->set('razorpay_order_id', $razorpayOrderId);

            $displayAmount = $amount = $orderData['amount'];

            if ($displayCurrency !== 'INR') {
                $url = "https://api.fixer.io/latest?symbols=$displayCurrency&base=INR";
                $exchange = json_decode(file_get_contents($url), true);
                $displayAmount = $exchange['rates'][$displayCurrency] * $amount / 100;
            }

            $mImage = base_url('assets/site/images/Daksha-Logo.png');

            $data = [
                "key" => $keyId,
                "amount" => $amount,
                "name" => $mRecord['user_name'],
                "description" => $mPackage,
                "image" => $mImage,
                "prefill" => [
                    "name" => $mRecord['user_name'],
                    "email" => $mRecord['user_email'],
                    "contact" => $mRecord['user_mobile'],
                ],
                "notes" => [
                    "address" => "Hello World",
                    "merchant_order_id" => "12312321",
                ],
                "theme" => [
                    "color" => "#F37254"
                ],
                "order_id" => $razorpayOrderId,
            ];

            if ($displayCurrency !== 'INR') {
                $data['display_currency'] = $displayCurrency;
                $data['display_amount'] = $displayAmount;
            }

            $json = json_encode($data);
            $datavalue['razor'] = $json;
            $datavalue['user_key'] = $mUserKey;

            return view('automatic', $datavalue);
        } else {
            $ts1 = strtotime($mRecord['user_date_updated']);
            $ts2 = strtotime(date("Y-m-d H:i:s"));
            $seconds_diff = $ts1 - $ts2;

            if ($seconds_diff < 0) {
                $api = new Api(RAZORPAY_KEY, RAZORPAY_SECRET_KEY);
                $mPaymentStatus = $mRecord['user_payment_status'];
                $mPlan = $mRecord['user_plan'];
                $mUserKey = $mRecord['user_key'];
                $mReceiptKey = $this->mGenerateRandomNumber();

                $prices = [1 => 1770, 2 => 4130, 3 => 7080, 4 => 1180, 5 => 3540];
                $packages = [
                    1 => "JUNIOR ADVOCATES (BELOW 10 YEARS EXP)",
                    2 => "SENIOR ADVOCATES (BELOW 10 YEARS EXP)",
                    3 => "DONORS AND PROMOTORS",
                    4 => "STUDENTS",
                    5 => "GENERAL PUBLIC"
                ];

                $mPrice = ($prices[$mPlan] ?? 0) * 100;
                $mPackage = $packages[$mPlan] ?? "";

                $orderData = [
                    'receipt' => $mReceiptKey,
                    'amount' => $mPrice,
                    'currency' => 'INR',
                    'payment_capture' => 1
                ];

                $razorpayOrder = $api->order->create($orderData);
                $razorpayOrderId = $razorpayOrder['id'];
                $this->session->set('razorpay_order_id', $razorpayOrderId);

                $displayAmount = $amount = $orderData['amount'];

                if ($displayCurrency !== 'INR') {
                    $url = "https://api.fixer.io/latest?symbols=$displayCurrency&base=INR";
                    $exchange = json_decode(file_get_contents($url), true);
                    $displayAmount = $exchange['rates'][$displayCurrency] * $amount / 100;
                }

                $mImage = base_url('assets/site/images/Daksha-Logo.png');

                $data = [
                    "key" => $keyId,
                    "amount" => $amount,
                    "name" => $mRecord['user_name'],
                    "description" => $mPackage . " (Renewal)",
                    "image" => $mImage,
                    "prefill" => [
                        "name" => $mRecord['user_name'],
                        "email" => $mRecord['user_email'],
                        "contact" => $mRecord['user_mobile'],
                    ],
                    "notes" => [
                        "address" => "Renewal Payment",
                        "merchant_order_id" => "RENEWAL-" . $mReceiptKey,
                    ],
                    "theme" => [
                        "color" => "#F37254"
                    ],
                    "order_id" => $razorpayOrderId,
                ];

                if ($displayCurrency !== 'INR') {
                    $data['display_currency'] = $displayCurrency;
                    $data['display_amount'] = $displayAmount;
                }

                $json = json_encode($data);
                $datavalue['razor'] = $json;
                $datavalue['user_key'] = $mUserKey;

                return view('automatic', $datavalue);

            } else {
                $mIsAuthenticated = $this->usersModel->authenticateUser($mEmail, $mSecretPassword);
            if ($mIsAuthenticated) {
                $data = [
                    'user_logged_in' => 1,
                    'last_login' => date('Y-m-d H:i:s')
                ];
                
                if (!empty($data)) {
                    try {
                        $result = $this->usersModel->updateParentByKey($mRecord['user_key'], $data);
                        if ($result === false) {
                            log_message('error', 'Failed to update user data: ' . print_r($data, true));
                        }
                    } catch (\Exception $e) {
                        log_message('error', 'Exception when updating user data: ' . $e->getMessage());
                    }
                } else {
                    log_message('warning', 'No data to update for user');
                }
                
                $mSessionName = $this->session->get('session_name');
                $this->session->setFlashdata('success', 'Welcome ' . $mSessionName);
                return redirect()->to('home');
            } else {
                $this->session->setFlashdata('error', 'User not found.');
                return view('signin', $data);
            }
            }
        }
    } else {
        $this->session->setFlashdata('error', 'Something went wrong.' . $this->request->getMethod());
        return view('signin', $data);
    }
}
public function actionAdd()
{
    $data['navbar'] = "users";
    if ($this->request->getMethod() === 'POST') {
        $rules = [
            'name' => 'required',
            'email' => 'required|valid_email',
            'plan' => 'required',
            'password' => 'required',
            'confirm_password' => 'required|matches[password]',
        ];
        log_message('debug', 'in actionAdd');
        if (!$this->validate($rules)) {
            return view('add_user', ['validation' => $this->validator] + $data);
        }

        $mPrice = 0;
        $mPlan = $this->request->getPost('plan');
        $mName = $this->request->getPost('name');
        $mEmail = $this->request->getPost('email');
        $mMobile = $this->request->getPost('mobile');
        $mPassword = $this->request->getPost('password');
        $mKey = $this->mGenerateRandomNumber();
        $mReceiptKey = $this->mGenerateRandomNumber();
        $api = new Api(RAZORPAY_KEY, RAZORPAY_SECRET_KEY);

        if ($mPassword == $this->request->getPost('confirm_password')) {
            $mSecretPassword = base64_encode($mPassword);
            $userExists = $this->usersModel->checkUser($mEmail);
            if (!$userExists) {
                $data = [
                    'user_key' => $mKey,
                    'user_email' => $mEmail,
                    'user_name' => $mName,
                    'user_mobile' => $mMobile,
                    'user_plan' => $mPlan,
                    'user_password' => $mSecretPassword,
                    'user_date_added' => date('Y-m-d H:i:s'),
                    'user_date_updated' => date('Y-m-d H:i:s')
                ];
                $mInsert = $this->usersModel->addUser($data);
                if ($mInsert) {
                    [$mPrice, $mPackage] = $this->getPlanDetails($mPlan);

                    $orderData = [
                        'receipt' => $mReceiptKey,
                        'amount' => $mPrice,
                        'currency' => 'INR',
                        'payment_capture' => 1
                    ];

                    $razorpayOrder = $api->order->create($orderData);
                    $razorpayOrderId = $razorpayOrder['id'];
                    $this->session->set('razorpay_order_id', $razorpayOrderId);

                    $displayAmount = $amount = $orderData['amount'];
                    $displayCurrency = 'INR';

                    if ($displayCurrency !== 'INR') {
                        $url = "https://api.fixer.io/latest?symbols=$displayCurrency&base=INR";
                        $exchange = json_decode(file_get_contents($url), true);
                        $displayAmount = $exchange['rates'][$displayCurrency] * $amount / 100;
                    }

                    $mImage = base_url('assets/site/images/Daksha-Logo.png');

                    $data = [
                        "key" => RAZORPAY_KEY,
                        "amount" => $amount,
                        "name" => $mName,
                        "description" => $mPackage,
                        "image" => $mImage,
                        "prefill" => [
                            "name" => $mName,
                            "email" => $mEmail,
                            "contact" => $mMobile,
                        ],
                        "notes" => [
                            "address" => "Hello World",
                            "merchant_order_id" => "12312321",
                        ],
                        "theme" => [
                            "color" => "#F37254"
                        ],
                        "order_id" => $razorpayOrderId,
                    ];

                    if ($displayCurrency !== 'INR') {
                        $data['display_currency'] = $displayCurrency;
                        $data['display_amount'] = $displayAmount;
                    }

                    $json = json_encode($data);
                    return view('automatic', ['razor' => $json, 'user_key' => $mKey]);
                } else {
                    return redirect()->back()->with('error', 'Something went wrong, Please try again.');
                }
            } else {
                $mPaymentStatus = $userExists['user_payment_status'];
                $mPlan = $userExists['user_plan'];
                $mUserKey = $userExists['user_key'];
                if ($mPaymentStatus == 0) {
                    [$mPrice, $mPackage] = $this->getPlanDetails($mPlan);

                    $orderData = [
                        'receipt' => $mReceiptKey,
                        'amount' => $mPrice,
                        'currency' => 'INR',
                        'payment_capture' => 1
                    ];

                    $razorpayOrder = $api->order->create($orderData);
                    $razorpayOrderId = $razorpayOrder['id'];
                    $this->session->set('razorpay_order_id', $razorpayOrderId);

                    $displayAmount = $amount = $orderData['amount'];
                    $displayCurrency = 'INR';

                    if ($displayCurrency !== 'INR') {
                        $url = "https://api.fixer.io/latest?symbols=$displayCurrency&base=INR";
                        $exchange = json_decode(file_get_contents($url), true);
                        $displayAmount = $exchange['rates'][$displayCurrency] * $amount / 100;
                    }

                    $mImage = base_url('assets/site/images/Daksha-Logo.png');

                    $data = [
                        "key" => RAZORPAY_KEY,
                        "amount" => $amount,
                        "name" => $mName,
                        "description" => $mPackage,
                        "image" => $mImage,
                        "prefill" => [
                            "name" => $mName,
                            "email" => $mEmail,
                            "contact" => $mMobile,
                        ],
                        "notes" => [
                            "address" => "Hello World",
                            "merchant_order_id" => "12312321",
                        ],
                        "theme" => [
                            "color" => "#F37254"
                        ],
                        "order_id" => $razorpayOrderId,
                    ];

                    if ($displayCurrency !== 'INR') {
                        $data['display_currency'] = $displayCurrency;
                        $data['display_amount'] = $displayAmount;
                    }

                    $json = json_encode($data);
                    return view('automatic', ['razor' => $json, 'user_key' => $mUserKey]);
                } else {
                    return redirect()->back()->with('error', 'This email has been already taken.');
                }
            }
        } else {
            return redirect()->back()->with('error', 'The Password and Confirm password do not match!');
        }
    }
    return view('add_user', $data);
}

private function getPlanDetails($plan)
{
    switch ($plan) {
        case 1:
            return [1770 * 100, "JUNIOR ADVOCATES (BELOW 10 YEARS EXP)"];
        case 2:
            return [4130 * 100, "SENIOR ADVOCATES (BELOW 10 YEARS EXP)"];
        case 3:
            return [7080 * 100, "DONORS AND PROMOTORS"];
        case 4:
            return [1180 * 100, "STUDENTS"];
        case 5:
            return [3540 * 100, "GENERAL PUBLIC"];
        default:
            return [0, "UNKNOWN PLAN"];
    }
}
    public function actionVerify()
    {
        $success = true;
        $error = "Payment Failed";
        $mUserKey = $this->request->getPost('user_key');

        if (!empty($this->request->getPost('razorpay_payment_id'))) {
            $api = new Api(RAZORPAY_KEY, RAZORPAY_SECRET_KEY);
            try {
                $attributes = [
                    'razorpay_order_id' => $this->session->get('razorpay_order_id'),
                    'razorpay_payment_id' => $this->request->getPost('razorpay_payment_id'),
                    'razorpay_signature' => $this->request->getPost('razorpay_signature')
                ];

                $api->utility->verifyPaymentSignature($attributes);
            } catch (SignatureVerificationError $e) {
                $success = false;
                $error = 'Razorpay Error : ' . $e->getMessage();
            }

            if ($success === true) {
                $data = [
                    'user_payment_key' => $this->request->getPost('razorpay_payment_id'),
                    'user_payment_status' => 1,
                    'user_status' => 1,
                    'user_date_updated' => date('Y-m-d H:i:s', strtotime('+1 year')),
                ];

                $mInsert = $this->usersModel->updateParentByKey($mUserKey, $data);

                if ($mInsert) {
                    return redirect()->to('users/signin')->with('success', 'Payment Successful, Please login to continue.');
                } else {
                    return redirect()->to('users/signin')->with('error', 'Something went wrong, Please try again.');
                }
            } else {
                $deleteData = $this->usersModel->deleteParentByKey($mUserKey);
                if ($deleteData) {
                    return redirect()->to('signup')->with('success', 'User Deleted.');
                } else {
                    return redirect()->to('signup')->with('error', 'Failed, Something went wrong.');
                }
            }
        }
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    // private function getPlanDetails(int $plan): array
    // {
    //     $plans = [
    //         1 => ['price' => 1770, 'package' => "JUNIOR ADVOCATES (BELOW 10 YEARS EXP)"],
    //         2 => ['price' => 4130, 'package' => "SENIOR ADVOCATES (BELOW 10 YEARS EXP)"],
    //         3 => ['price' => 7080, 'package' => "DONORS AND PROMOTORS"],
    //         4 => ['price' => 1180, 'package' => "STUDENTS"],
    //         5 => ['price' => 3540, 'package' => "GENERAL PUBLIC "]
    //     ];

    //     return [$plans[$plan]['price'], $plans[$plan]['package']];
    // }

    private function prepareRazorpayData(string $razorpayOrderId, int $displayAmount, string $name, string $package, string $email, string $mobile): array
    {
        return [
            "key" => RAZORPAY_KEY,
            "amount" => $displayAmount,
            "name" => $name,
            "description" => $package,
            "image" => base_url('assets/site/images/Daksha-Logo.png'),
            "prefill" => [
                "name" => $name,
                "email" => $email,
                "contact" => $mobile,
            ],
            "notes" => [
                "address" => "Hello World",
                "merchant_order_id" => "12312321",
            ],
            "theme" => [
                "color" => "#F37254"
            ],
            "order_id" => $razorpayOrderId,
        ];
    }


    public function actionEnable($param = null)
    {
        $mSessionKey = $this->session->get('session_key');
        if (!$mSessionKey) {
            return view('login');
        }

        if (!$param) {
            return redirect()->to('users')->with('error', 'Something went wrong.');
        }

        $getData = $this->usersModel->getParentByKey($param);
        if (empty($getData)) {
            return redirect()->to('users')->with('error', 'Record not found.');
        }

        $result = $this->usersModel->updateParentByKey($param, ['user_status' => 1]);
        if ($result) {
            return redirect()->to('users')->with('success', $getData['user_name'] . ' Enabled');
        }

        return redirect()->to('users')->with('error', 'Failed. Something went wrong.');
    }

    public function actionDisable($param = null)
    {
        $mSessionKey = $this->session->get('session_key');
        if (!$mSessionKey) {
            return view('login');
        }

        if (!$param) {
            return redirect()->to('users')->with('error', 'Something went wrong.');
        }

        $getData = $this->usersModel->getParentByKey($param);
        if (empty($getData)) {
            return redirect()->to('users')->with('error', 'Record not found.');
        }

        $result = $this->usersModel->updateParentByKey($param, ['user_status' => 0]);
        if ($result) {
            return redirect()->to('users')->with('success', $getData['user_name'] . ' Disabled.');
        }

        return redirect()->to('users')->with('error', 'Failed. Something went wrong.');
    }

    public function actionDelete($param = null)
    {
        $mSessionKey = $this->session->get('session_key');
        if (!$mSessionKey) {
            return view('login');
        }

        if (!$param) {
            return redirect()->to('users')->with('error', 'Something went wrong.');
        }

        $getData = $this->usersModel->getParentByKey($param);
        if (empty($getData)) {
            return redirect()->to('users')->with('error', 'Record not found.');
        }

        $deleteData = $this->usersModel->deleteParentByKey($param);
        if ($deleteData) {
            return redirect()->to('users')->with('success', $getData['user_name'] . ' Deleted.');
        }

        return redirect()->to('users')->with('error', 'Failed, Something went wrong.');
    }

    public function forgotPassword()
    {
        return view('forgot_password');
    }

    public function changePassword($param)
    {
        if (!$param) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }

        return view('change_password', ['key' => $param]);
    }

    public function actionChange($param)
    {
        if (!$param) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }

        $mPassword = $this->request->getPost('password');
        $mSecretPassword = base64_encode($mPassword);

        $mInsert = $this->usersModel->updateParentByKey($param, ['user_password' => $mSecretPassword]);
        if ($mInsert) {
            return redirect()->to('users/signin')->with('success', 'Password changed successfully.');
        }

        return redirect()->to('users/signin')->with('error', 'Something went wrong, Please try again.');
    }

    public function actionSendLink()
    {
        if (!$this->request->is('post')) {
            return view('signin')->with('error', 'Something went wrong.');
        }

        $rules = [
            'email' => 'required|valid_email',
        ];

        if (!$this->validate($rules)) {
            return view('forgot_password')->with('error', 'Validation Error');
        }

        $mEmail = $this->request->getPost('email');
        $mIsAuthenticated = $this->usersModel->getUserByEmail($mEmail);

        if (empty($mIsAuthenticated)) {
            $this->session->setFlashdata('error','User Does not Exist');
            return view('signin');
        }

        $mName = $mIsAuthenticated['user_name'];
        $mKey = $mIsAuthenticated['user_key'];
        $mLink = base_url('users/changePassword/' . $mKey);

        $message = $this->getPasswordResetEmailContent($mName, $mLink);

        $this->email->setFrom('nithin@dakshalegal.com', 'Daksha Legal');
        $this->email->setTo($mEmail);
        $this->email->setSubject('Reset Password');
        $this->email->setMessage($message);

        if ($this->email->send()) {
            $this->session->setFlashdata('success','Reset password link sent successfully.');
            return view('signin');
        }
        $this->session->setFlashdata('error', 'Failed to send email. Please try again.');
        return view('signin');
    }

    public function sendEmail($subject, $message, $to)
    {
        $this->email->setFrom('info@dakshalegal.com', 'Daksha Legal');
        $this->email->setTo($to);
        $this->email->setSubject($subject);
        $this->email->setMessage($message);

        try {
            return $this->email->send() ? 1 : 0;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
            return 0;
        }
    }

    

    private function getPasswordResetEmailContent(string $name, string $link): string
    {
        return "
        <html>
        <head>
        </head>
        <body>
        <h3>Hello {$name},</h3>
        <p>Please click this link to reset your password</p><br>
        <a href='{$link}'>Change Password</a>
        <h4>Daksha Legal Team</h4><br>
        </body>
        </html>";
    }
}
?>