<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Terms extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $CI = & get_instance();
        $CI->load->database();
        $CI->load->library('session');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->load->library('upload');
        date_default_timezone_set("Asia/Kolkata");
        $this->load->helper('date');
        //$this->load->model('users_model');
        $this->load->model('category_model');
        $this->load->model('article_model');
        $this->load->model('lawyers_model');
        $this->load->model('bareact_model');
        $this->load->model('section_model');
        $this->load->model('judgement_model');
        $this->load->model('court_model');
        $this->load->model('subcourt_model');
        error_reporting(0);
        //error_reporting(E_ALL);
        //ini_set('display_errors', 1);
    }

    public function index() {
        $data['home'] = "terms";
        $this->load->view('terms', $data);
    }

    public function actionView($param) {
        if ($param) {
            $data['home'] = "terms";
            $data['subcourt'] = $this->subcourt_model->getParentByKey($param);
            $data['subcourts'] = $this->subcourt_model->getAllParentForSite();
            $this->load->view('view_subcourt', $data);
        } else {
            show_404();
        }
    }

    public function mGenerateRandomNumber() {
        $key = '';
        $keys = array_merge(range('a', 'z'), range('A', 'Z'), range(0, 9));
        for ($i = 0; $i < 25; $i++) {
            $key .= $keys[array_rand($keys)];
        }
        return $key;
    }

    public function sendEmail($subject, $message, $to) {
        $this->load->library('email');
        $config = array(
            'mailtype' => 'html',
            'charset' => 'utf-8',
            'priority' => '1'
        );
        $this->email->initialize($config);
        $this->email->from('info@vendorglobe.com', '');
        $this->email->to($to);
        $this->email->subject($subject);
        $this->email->message($message);
        try {
            $suc = $this->email->send();
            if ($suc) {
                return 1;
            } else {
                return 0;
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    public function actionLogout() {
        $this->session->sess_destroy();
        redirect('home');
    }

}
