<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class News extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $models = [];

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();
        $this->email = \Config\Services::email();

        $this->models = [
            'category' => new \App\Models\CategoryModel(),
            'lawyers' => new \App\Models\LawyersModel(),
            'bareact' => new \App\Models\BareactModel(),
            'section' => new \App\Models\SectionModel(),
            'judgement' => new \App\Models\JudgementModel(),
            'news' => new \App\Models\NewsModel(),
        ];

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function index()
    {
        $data = [
            'home' => "news",
            'articles' => $this->models['news']->getAllParentForSite(),
            'tags' => $this->models['category']->getAllParentForSite(),
        ];
        return view('news', $data);
    }

    public function actionView($param)
    {
        $mSessionKey = $this->session->get('session_key');
        if (!empty($mSessionKey)) {
            if ($param) {
                $data = [
                    'home' => "news",
                    'news' => $this->models['news']->getParentByKey($param),
                    'tags' => $this->models['category']->getAllParentForSite(),
                    'articles' => $this->models['news']->getAllParentForSite(),
                ];
                return view('view_news', $data);
            } else {
                throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
            }
        } else {
            $data = [
                'home' => "news",
                'news' => $this->models['news']->getParentByKey($param),
                'tags' => $this->models['category']->getAllParentForSite(),
                'articles' => $this->models['news']->getAllParentForSite(),
            ];
            return view('view_news', $data);
        }
    }

    public function view($param)
    {
        if ($param) {
            $data['article'] = $this->models['news']->getParentByKey($param);
            return view('view_news', $data);
        } else {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }
    }

    public function actionRead($param)
    {
        $mSessionKey = $this->session->get('session_key');
        $data['news'] = $this->models['news']->getParentByKey($param);
        if ($param) {
            if ($mSessionKey) {
                return view('view_news', $data);
            } else {
                return view('signin', $data);
            }
        } else {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    public function sendEmail($subject, $message, $to)
    {
        $this->email->setFrom('info@vendorglobe.com', '');
        $this->email->setTo($to);
        $this->email->setSubject($subject);
        $this->email->setMessage($message);
        
        try {
            return $this->email->send() ? 1 : 0;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
            return 0;
        }
    }

    public function actionLogout()
    {
        $this->session->destroy();
        return redirect()->to('home');
    }
}