<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class Kannada extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $models = [];

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();
        $this->email = \Config\Services::email();

        $this->models = [
            'category' => new \App\Models\CategoryModel(),
            'kannada' => new \App\Models\KannadaModel(),
            'lawyers' => new \App\Models\LawyersModel(),
            'bareact' => new \App\Models\BareactModel(),
            'section' => new \App\Models\SectionModel(),
            'judgement' => new \App\Models\JudgementModel(),
        ];

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function index()
    {
        $data = [
            'home' => "kannada",
            'articles' => $this->models['kannada']->getAllParentForSite(),
        ];
        return view('kannada', $data);
    }

    public function actionView($param = null)
    {
        $mSessionKey = $this->session->get('session_key');
        if ($mSessionKey) {
            if ($param) {
                $data = [
                    'kannada' => $this->models['kannada']->getParentByKey($param),
                    'tags' => $this->models['category']->getAllParentForSite(),
                ];
                return view('view_kannada', $data);
            } else {
                throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
            }
        } else {
            return view('signin');
        }
    }

    public function view($param = null)
    {
        if ($param) {
            $data['article'] = $this->models['kannada']->getParentByKey($param);
            return view('view_kannada', $data);
        } else {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }
    }

    public function actionRead($param = null)
    {
        $mSessionKey = $this->session->get('session_key');
        $data['kannada'] = $this->models['kannada']->getParentByKey($param);
        if ($param) {
            if ($mSessionKey) {
                return view('view_kannada', $data);
            } else {
                return view('signin', $data);
            }
        } else {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    public function sendEmail($subject, $message, $to)
    {
        $this->email->setFrom('info@vendorglobe.com', '');
        $this->email->setTo($to);
        $this->email->setSubject($subject);
        $this->email->setMessage($message);
        
        try {
            return $this->email->send() ? 1 : 0;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
            return 0;
        }
    }

    public function actionLogout()
    {
        $this->session->destroy();
        return redirect()->to('home');
    }
}