<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class District extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $models = [];

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();
        $this->email = \Config\Services::email();

        $this->models = [
            'category' => new \App\Models\CategoryModel(),
            'article' => new \App\Models\ArticleModel(),
            'lawyers' => new \App\Models\LawyersModel(),
            'bareact' => new \App\Models\BareactModel(),
            'section' => new \App\Models\SectionModel(),
            'judgement' => new \App\Models\JudgementModel(),
            'district' => new \App\Models\DistrictModel(),
            'new_lawyers' => new \App\Models\NewLawyersModel(),
        ];

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function index()
    {
        $data = [
            'home' => "new_lawyer",
            'district' => $this->models['district']->getAllParentForSite(),
        ];
        return view('new_lawyer', $data);
    }

    public function actionView($param = null)
    {
        if ($param) {
            $data = [
                'home' => "view_newlawyers",
                'new_lawyers' => $this->models['new_lawyers']->getParentByKey($param),
            ];
            return view('view_newlawyers', $data);
        } else {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    public function sendEmail($subject, $message, $to)
    {
        $this->email->setFrom('info@vendorglobe.com', '');
        $this->email->setTo($to);
        $this->email->setSubject($subject);
        $this->email->setMessage($message);
        
        try {
            return $this->email->send() ? 1 : 0;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
            return 0;
        }
    }

    public function actionLogout()
    {
        $this->session->destroy();
        return redirect()->to('home');
    }
}