<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class Bareacts extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $models = [];

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();
        $this->upload = \Config\Services::upload();

        $this->models = [
            'category' => new \App\Models\CategoryModel(),
            'article' => new \App\Models\ArticleModel(),
            'lawyers' => new \App\Models\LawyersModel(),
            'bareact' => new \App\Models\BareactModel(),
            'section' => new \App\Models\SectionModel(),
            'judgement' => new \App\Models\JudgementModel(),
        ];

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function index()
    {
        $data = [
            'home' => "bareacts",
            'bareacts' => $this->models['bareact']->getAllParentForSite()
        ];
        return view('bare_acts', $data);
    }

    public function actionView($param)
    {
        $mSessionKey = $this->session->get('session_key');
        if ($mSessionKey) {
            if ($param) {
                $data = [
                    'home' => "bareacts",
                    'bareact' => $this->models['bareact']->getParentByKey($param),
                    'sections' => $this->models['section']->getAllParentByChildKey($param)
                ];
                return view('bare_act_sections', $data);
            }
            return redirect()->to('home');
        }
        return view('signin');
    }

    public function actionDowload($id)
    {
        $mSessionKey = $this->session->get('session_key');
        if ($mSessionKey) {
            if (!empty($id)) {
                return $this->generatePDF($id, true);
            }
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }
        return view('signin');
    }
    
    public function actionDowloadForMobile($id)
    {
        if (!empty($id)) {
            return $this->generatePDF($id, true);
        }
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }

    public function actionPdf($id)
    {
        $mSessionKey = $this->session->get('session_key');
        if ($mSessionKey) {
            if (!empty($id)) {
                $data = [
                    'home' => "bareacts",
                    'bareact' => $this->models['bareact']->getParentByKey($id),
                    'sections' => $this->models['section']->getAllParentByChildKey($id)
                ];
                return view('bareact_pdf', $data);
            }
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }
        return view('signin');
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    public function sendEmail($subject, $message, $to)
    {
        $email = \Config\Services::email();
        $email->setFrom('info@vendorglobe.com', '');
        $email->setTo($to);
        $email->setSubject($subject);
        $email->setMessage($message);
        
        try {
            return $email->send() ? 1 : 0;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
            return 0;
        }
    }

    public function actionViewApp($param)
    {
        if ($param) {
            $data = [
                'home' => "bareacts",
                'bareact' => $this->models['bareact']->getParentByKey($param),
                'sections' => $this->models['section']->getAllParentByChildKey($param)
            ];
            return view('bare_act_sections', $data);
        }
        return redirect()->to('home');
    }

    public function actionViewDownload($id)
    {
        if (!empty($id)) {
            return $this->generatePDF($id, true);
        }
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }

    private function generatePDF($id, $download = false)
    {
        $bareact = $this->models['bareact']->getParentByKey($id);
        $siteaddressAPI = base_url('home/bareactPdf') . "/" . $id;
        $html = file_get_contents($siteaddressAPI);
        
        $dompdf = new \Dompdf\Dompdf();
        $dompdf->set_option('isRemoteEnabled', TRUE);
        $dompdf->set_option("isPhpEnabled", true);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('legal', 'portrait');
        $dompdf->render();

        $name = $bareact['ba_title'] . ".pdf";
        return $dompdf->stream($name, ["Attachment" => $download ? 1 : 0]);
    }

    public function actionLogout()
    {
        $this->session->destroy();
        return redirect()->to('home');
    }
}