<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class Articles extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $models = [];

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();
        $this->upload = \Config\Services::upload();

        $this->models = [
            'category' => new \App\Models\CategoryModel(),
            'article' => new \App\Models\ArticleModel(),
            'lawyers' => new \App\Models\LawyersModel(),
            'bareact' => new \App\Models\BareactModel(),
            'section' => new \App\Models\SectionModel(),
            'judgement' => new \App\Models\JudgementModel(),
        ];

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function index()
    {
        $data = [
            'home' => "articles",
            'articles' => $this->models['article']->getAllParentForSite(),
            'tags' => $this->models['category']->getAllParentForSite()
        ];
        return view('articles', $data);
    }

    public function actionView($param)
    {
        $mSessionKey = $this->session->get('session_key');
        if ($mSessionKey) {
            if ($param) {
                $data = [
                    'home' => "articles",
                    'article' => $this->models['article']->getParentByKey($param),
                    'tags' => $this->models['category']->getAllParentForSite(),
                    'articles' => $this->models['article']->getAllParentForSite()
                ];
                return view('view_article', $data);
            } 
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        } 
        return view('signin');
    }

    public function view($param)
    {
        if ($param) {
            $data['article'] = $this->models['article']->getParentByKey($param);
            return view('view_article', $data);
        }
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }

    public function actionRead($param)
    {
        $mSessionKey = $this->session->get('session_key');
        $data['article'] = $this->models['article']->getParentByKey($param);
        if ($param) {
            if ($mSessionKey) {
                return view('view_article', $data);
            } 
            return view('signin', $data);
        }
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    public function sendEmail($subject, $message, $to)
    {
        $email = \Config\Services::email();
        $email->setFrom('info@vendorglobe.com', '');
        $email->setTo($to);
        $email->setSubject($subject);
        $email->setMessage($message);
        
        try {
            return $email->send() ? 1 : 0;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
            return 0;
        }
    }

    public function actionLogout()
    {
        $this->session->destroy();
        return redirect()->to('home');
    }
}