<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

class AppServices extends BaseController
{
    protected $helpers = ['form', 'url', 'date'];
    protected $models = [];

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);

        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
        $this->validation = \Config\Services::validation();
        $this->upload = \Config\Services::upload();

        $this->models = [
            'category' => new \App\Models\CategoryModel(),
            'article' => new \App\Models\ArticleModel(),
            'lawyers' => new \App\Models\LawyersModel(),
            'bareact' => new \App\Models\BareactModel(),
            'section' => new \App\Models\SectionModel(),
            'judgement' => new \App\Models\JudgementModel(),
            'news' => new \App\Models\NewsModel(),
        ];

        date_default_timezone_set("Asia/Kolkata");
        error_reporting(0);
    }

    public function bareActDetails($param)
    {
        if ($param) {
            $data = [
                'home' => "bareacts",
                'bareact' => $this->models['bareact']->getParentByKey($param),
                'sections' => $this->models['section']->getAllParentByChildKey($param)
            ];
            return view('app/bare_act_sections', $data);
        }
        return redirect()->to('home');
    }

    public function bareActView($param)
    {
        if ($param) {
            $data = [
                'home' => "bareacts",
                'bareact' => $this->models['bareact']->getParentByKey($param),
                'sections' => $this->models['section']->getAllParentByChildKey($param)
            ];
            return view('bare_act_sections', $data);
        }
        return redirect()->to('home');
    }

    public function bareActDownload($id)
    {
        if (!empty($id)) {
            $bareact = $this->models['bareact']->getParentByKey($id);
            $siteaddressAPI = base_url('home/bareactPdf') . "/" . $id;
            $html = file_get_contents($siteaddressAPI);
            
            $dompdf = new \Dompdf\Dompdf();
            $dompdf->set_option('isRemoteEnabled', TRUE);
            $dompdf->set_option("isPhpEnabled", true);
            $dompdf->loadHtml($html);
            $dompdf->setPaper('legal', 'portrait');
            $dompdf->render();

            $name = $bareact['ba_title'] . ".pdf";
            return $dompdf->stream($name, ["Attachment" => 1]);
        }
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }

    public function bareActViewPDF($id)
    {
        if (!empty($id)) {
            $data = [
                'home' => "bareacts",
                'bareact' => $this->models['bareact']->getParentByKey($id),
                'sections' => $this->models['section']->getAllParentByChildKey($id)
            ];
            return view('bareact_pdf', $data);
        }
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }

    public function judgementViewPDF($id)
    {
        if ($id) {
            $data['judgement'] = $this->models['judgement']->getParentByKey($id);
            return view('app/judgement_info', $data);
        }
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }

    public function newsViewPDF($id)
    {
        if ($id) {
            $data['news'] = $this->models['news']->getParentByKey($id);
            return view('app/news_info', $data);
        }
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }

    public function articleViewPDF($id)
    {
        if ($id) {
            $data['article'] = $this->models['article']->getParentByKey($id);
            return view('app/article_info', $data);
        }
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }

    private function mGenerateRandomNumber(): string
    {
        return bin2hex(random_bytes(12));
    }

    public function sendEmail($subject, $message, $to)
    {
        $email = \Config\Services::email();
        $email->setFrom('info@vendorglobe.com', '');
        $email->setTo($to);
        $email->setSubject($subject);
        $email->setMessage($message);
        
        try {
            return $email->send() ? 1 : 0;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
            return 0;
        }
    }

    public function actionLogout()
    {
        $this->session->destroy();
        return redirect()->to('home');
    }
}