<!DOCTYPE html>
<html lang="en">
    <?php $this->load->view('admin/partials/header'); ?>
    <body class="c-app">
        <?php $this->load->view('admin/partials/sidenav'); ?>
        <div class="c-wrapper c-fixed-components">
            <?php $this->load->view('admin/partials/navbar'); ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Users
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?php echo base_url('admin/users/addUser'); ?>">Add New</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?php $this->load->view('admin/partials/alerts'); ?>
                                            <table class="table table-responsive-sm table-hover table-outline mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>Sl No</th>
                                                        <th>Name</th>
                                                        <th>Email</th>
                                                        <th>Plan</th>
                                                        <th>Payment Status</th>
                                                        <th>Status</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if (!empty($users)) { ?>

                                                        <?php
                                                        $i = 0;
                                                        foreach ($users as $key => $user) {
                                                            $i++;
                                                            ?>
                                                            <tr>
                                                                <td>
                                                                    <?php echo $i; ?>
                                                                </td>
                                                                <td>
                                                                    <?php echo $user['user_name']; ?>
                                                                </td>
                                                                <td>
                                                                    <?php echo $user['user_email']; ?>
                                                                </td>
                                                                <td>
                                                                    <?php
                                                                    $timestamp = strtotime($user['user_date_added']);
                                                                    //echo date('d-m-Y', $timestamp);
                                                                    ?>
                                                                    <?php if ($user['user_plan'] == 1) { ?>
                                                                        <span class="badge badge-success">JUNIOR ADVOCATES (BELOW 10 YEARS EXP)</span>
                                                                    <?php } elseif ($user['user_plan'] == 2) { ?>
                                                                        <span class="badge badge-success">SENIOR ADVOCATES (BELOW 10 YEARS EXP)</span>
                                                                    <?php } else { ?>
                                                                        <span class="badge badge-success">DONORS AND PROMOTORS</span>
                                                                    <?php } ?>
                                                                </td>
                                                                <td>
                                                                    <?php if ($user['user_payment_status'] == 1) { ?>
                                                                        <span class="badge badge-success">Paid</span>
                                                                    <?php } else { ?>
                                                                        <span class="badge badge-success">Not Paid</span>
                                                                    <?php } ?>
                                                                </td>
                                                                <td>
                                                                    <?php if ($user['user_status'] == 1 || $user['user_payment_status'] == 1) { ?>
                                                                        <span class="badge badge-success">Enabled</span>
                                                                    <?php } else { ?>
                                                                        <span class="badge badge-success">Disabled</span>
                                                                    <?php } ?>
                                                                </td>
                                                                <td>
                                                                    <?php if ($user['user_status'] == 0 || $user['user_payment_status'] == 0) { ?>
                                                                        <a href="<?php echo base_url('admin/users/actionEnable/') . $user['user_key']; ?>" class="badge badge-success mb-1">Enable</a>
                                                                    <?php } else { ?>
                                                                        <a href="<?php echo base_url('admin/users/actionDisable/') . $user['user_key']; ?>" class="badge badge-danger mb-1">Disable</a>
                                                                    <?php } ?>
                                                                    <a href="<?php echo base_url('admin/users/edit/') . $user['user_key']; ?>" class="badge badge-success btn-info mb-1">Edit</a>
                                                                    <a href="#" data-toggle="modal" data-target="#changepassword-<?php echo $i; ?>" class="badge badge-success btn-info mb-1">Change Password</a>
                                                                    <a onclick="return confirm('Are you sure?')" href="<?php echo base_url('admin/users/actionDelete/') . $user['user_key']; ?>" class="badge badge-success btn-danger mb-1"><i class="fa fa-trash"></i></a>
                                                                </td>
                                                            </tr>

                                                        <?php } ?>

                                                    <?php } ?>


                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?php $this->load->view('admin/partials/footer'); ?>
            </div>
        </div>
        <!-- CoreUI and necessary plugins-->
        <?php $this->load->view('admin/partials/scripts'); ?>
        <?php
        $i = 0;
        foreach ($users as $key => $user) {
            $i++;
            ?>

            <!-- The Modal -->
            <div class="modal" id="changepassword-<?php echo $i; ?>">
                <div class="modal-dialog">
                    <div class="modal-content">

                        <!-- Modal Header -->
                        <div class="modal-header">
                            <h4 class="modal-title"><?php echo $user['user_name']; ?> : Change Password</h4>
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                        </div>

                        <form method="POST" action="<?php echo base_url('admin/users/actionChangePassword/' . $user['user_key']); ?>" enctype="multipart/form-data">

                            <!-- Modal body -->
                            <div class="modal-body">
                                <div class="form-group">
                                    <label for="exampleFormControlInput1">New Password</label>
                                    <input required="" name="password" id="password" type="password" class="form-control" />
                                </div> 
                            </div>

                            <!-- Modal footer -->
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>

                        </form>

                    </div>
                </div>
            </div>

        <?php } ?>
        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });
        </script>
    </body>
</html>