<!DOCTYPE html>
<html lang="en">
    <?php $this->load->view('admin/partials/header'); ?>
    <body class="c-app">
        <?php $this->load->view('admin/partials/sidenav'); ?>
        <div class="c-wrapper c-fixed-components">
            <?php $this->load->view('admin/partials/navbar'); ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Edit Tag
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?php echo base_url('admin/tags'); ?>">Tags List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">

                                            <div class="card-body">
                                                <form id="categoryForm" method="POST" action="<?php echo base_url('admin/tags/actionUpdateTag/'); ?><?php echo $tag['category_key']; ?>" enctype="multipart/form-data">
                                                    <?php
                                                    if (!empty($tag)) {
                                                        $categoryname = $tag['category'];
                                                        $categorykey = $tag['category_key'];
                                                    } else {
                                                        $categoryname = set_value('category');
                                                    }
                                                    ?>
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label for="exampleFormControlInput1">Tag Name</label>
                                                                <input value="<?php echo $categoryname; ?>" required="" type="text" class="form-control" id="category" name="category">
                                                            </div>  
                                                        </div>
                                                    </div>
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?php $this->load->view('admin/partials/footer'); ?>
            </div>
        </div>
        <!-- CoreUI and necessary plugins-->
        <?php $this->load->view('admin/partials/scripts'); ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#previewImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#image").change(function () {
                readURL(this);
            });
        </script>
    </body>
</html>