<!DOCTYPE html>
<html lang="en">
    <?php $this->load->view('admin/partials/header'); ?>
    <body class="c-app">
        <?php $this->load->view('admin/partials/sidenav'); ?>
        <div class="c-wrapper c-fixed-components">
            <?php $this->load->view('admin/partials/navbar'); ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Edit Sub Court
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?php echo base_url('admin/subcourts'); ?>">Sub Courts List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">

                                            <?php
                                            if (!empty($subcourt)) {
                                                $courtKey = $subcourt['subcourt_court_key'];
                                                $title = $subcourt['subcourt_name'];
                                                $image = $subcourt['subcourt_image'];
                                                $desc = $subcourt['subcourt_desc'];
                                                $subcourtkey = $subcourt['subcourt_key'];
                                            } else {
                                                $categoryname = set_value('category');
                                            }
                                            ?>

                                            <?php $this->load->view('admin/partials/alerts'); ?>
                                            <form id="articleForm" method="POST" action="<?php echo base_url('admin/subcourts/actionUpdate/' . $subcourtkey); ?>" enctype="multipart/form-data">
                                                <img id="previewImage" height="400" class="card-img-top" src="<?php echo base_url('uploads/courts/'); ?><?php echo $image; ?>" alt="Court Image">
                                                <div class="row mt-3">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1">Image</label>
                                                            <input name="image" id="image" type="file" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Court:</label>
                                                            <select class="form-control" name="court" id="court" required="">
                                                                <option selected="" disabled="" value="">Select Court</option>
                                                                <?php foreach ($courts as $key => $court) { ?>
                                                                    <?php if ($courtKey == $court['court_key']) { ?>
                                                                        <option selected="" value="<?php echo $court['court_key']; ?>"><?php echo $court['court_name']; ?></option>
                                                                    <?php } else { ?>
                                                                        <option value="<?php echo $court['court_key']; ?>"><?php echo $court['court_name']; ?></option>
                                                                    <?php } ?>
                                                                <?php } ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Title:</label>
                                                            <input value="<?php echo $title; ?>" required="" name="title" id="title" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Content:</label>
                                                            <textarea class="form-control" name="description" id="editor" required="required"><?php echo html_entity_decode($desc); ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?php $this->load->view('admin/partials/footer'); ?>
            </div>
        </div>
        <!-- CoreUI and necessary plugins-->
        <?php $this->load->view('admin/partials/scripts'); ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#previewImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#image").change(function () {
                readURL(this);
            });
        </script>
    </body>
</html>