<!DOCTYPE html>
<html lang="en">
    <?php $this->load->view('admin/partials/header'); ?>
    <body class="c-app">
        <?php $this->load->view('admin/partials/sidenav'); ?>
        <div class="c-wrapper c-fixed-components">
            <?php $this->load->view('admin/partials/navbar'); ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Edit Bare Act Section
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?php echo base_url('admin/sections'); ?>">Bare Act Sections List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?php
                                            if (!empty($parent)) {
                                                $title = $parent['sec_title'];
                                                $par = $parent['sec_particular'];
                                                $subtitle = $parent['sec_subtitle'];
                                                $subpar = $parent['sec_subparticular'];
                                                $data = json_decode($parent['sec_data']);
                                                $secKey = $parent['sec_key'];
                                                $baKey = $parent['sec_ba_key'];
                                                //echo $baKey;
                                            } else {
                                                $title = set_value('title');
                                                $par = set_value('particular');
                                                $subtitle = set_value('subtitle');
                                                $subpar = set_value('subparticular');
                                                $baKey = set_value('bareact');
                                            }
                                            ?>
                                            <?php $this->load->view('admin/partials/alerts'); ?>
                                            <form id="articleForm" method="POST" action="<?php echo base_url('admin/sections/actionUpdateSection/' . $secKey); ?>" enctype="multipart/form-data">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Bare Act:</label>
                                                            <select required="" class="form-control" name="bareact">
                                                                <option selected="" value="" disabled="">Select Bare Act</option>
                                                                <?php foreach ($bareacts as $key => $bareact) { ?>
                                                                    <?php if ($baKey == $bareact['ba_key']) { ?>
                                                                        <option selected="" value="<?php echo $bareact['ba_key']; ?>"><?php echo $bareact['ba_title']; ?></option>
                                                                    <?php } else { ?>
                                                                        <option value="<?php echo $bareact['ba_key']; ?>"><?php echo $bareact['ba_title']; ?></option>
                                                                    <?php } ?>
                                                                <?php } ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Title:</label>
                                                            <input value="<?php echo $title; ?>" required="" name="title" id="title" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Particulars:</label>
                                                            <input value="<?php echo $par; ?>" required="" name="particular" id="particular" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Sub Title:</label>
                                                            <input value="<?php echo $subtitle; ?>" name="subtitle" id="subtitle" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Sub Particulars:</label>
                                                            <input value="<?php echo $subpar; ?>" name="subparticular" id="subparticular" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <table id="myTable" class="table order-list table-responsive-sm table-hover table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>Title</th>
                                                                    <th>Content</th>
                                                                    <th></th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                $count = 0;
                                                                foreach ($data as $key => $value) {
                                                                    $count++;
                                                                    ?>
                                                                    <?php if ($count == 1) { ?>
                                                                        <tr>
                                                                            <td>
                                                                                <textarea required="" name="data[<?php echo $count; ?>][]" class="form-control" rows="5"><?php echo $value[0]; ?></textarea>
                                                                            </td>
                                                                            <td>
                                                                                <textarea required="" name="data[<?php echo $count; ?>][]" class="form-control" rows="5"><?php echo $value[1]; ?></textarea>
                                                                            </td>
                                                                            <td>
        <!--                                                                                <a class="ibtnDel btn btn-sm btn-danger text-white"><i class="fa fa-trash"></i></a>-->
                                                                            </td>
                                                                        </tr>
                                                                    <?php } else { ?>
                                                                        <tr>
                                                                            <td>
                                                                                <textarea required="" name="data[<?php echo $count; ?>][]" class="form-control" rows="5"><?php echo $value[0]; ?></textarea>
                                                                            </td>
                                                                            <td>
                                                                                <textarea required="" name="data[<?php echo $count; ?>][]" class="form-control" rows="5"><?php echo $value[1]; ?></textarea>
                                                                            </td>
                                                                            <td>
                                                                                <input type="button" class="ibtnDel btn btn-danger"  value="Delete">
                                                                            </td>
                                                                        </tr>
                                                                    <?php } ?>

                                                                <?php } ?>

                                                            </tbody>
                                                            <tfoot>
                                                                <tr>
                                                                    <td colspan="5" style="text-align: left;">
                                                                        <input type="button" class="btn btn-info btn-block" id="addrow" value="Add Another Section" />
                                                                    </td>
                                                                </tr>
                                                            </tfoot>
                                                        </table>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?php $this->load->view('admin/partials/footer'); ?>
            </div>
        </div>
        <!-- CoreUI and necessary plugins-->
        <?php $this->load->view('admin/partials/scripts'); ?>

        <script>
            $(document).ready(function () {
                var counter = 2;

                $("#addrow").on("click", function () {
                    var rowCount = $('#myTable tr').length;
                    var count = rowCount - 1;
                    alert(count);
                    var newRow = $("<tr>");
                    var cols = "";

                    cols += '<td><textarea name="data[' + count + '][]" class="form-control" rows="5"></textarea></td>';
                    cols += '<td><textarea name="data[' + count + '][]" class="form-control" rows="5"></textarea></td>';

                    cols += '<td><input type="button" class="ibtnDel btn btn-danger"  value="Delete"></td>';
                    newRow.append(cols);
                    $("table.order-list").append(newRow);
                    counter++;
                });

                $("table.order-list").on("click", ".ibtnDel", function (event) {
                    $(this).closest("tr").remove();
                    counter -= 1
                });


            });

            function calculateRow(row) {
                var price = +row.find('input[name^="price"]').val();

            }

            function calculateGrandTotal() {
                var grandTotal = 0;
                $("table.order-list").find('input[name^="price"]').each(function () {
                    grandTotal += +$(this).val();
                });
                $("#grandtotal").text(grandTotal.toFixed(2));
            }
        </script>
    </body>
</html>