<!DOCTYPE html>
<html lang="en">
    <?php $this->load->view('admin/partials/header'); ?>
    <body class="c-app">
        <?php $this->load->view('admin/partials/sidenav'); ?>
        <div class="c-wrapper c-fixed-components">
            <?php $this->load->view('admin/partials/navbar'); ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Courts
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?php echo base_url('admin/courts/add'); ?>">Add New</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?php $this->load->view('admin/partials/alerts'); ?>
                                            <table class="table table-responsive-sm table-hover table-outline mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>Sl No</th>
                                                        <th>Name</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if (!empty($courts)) { ?>
                                                        <?php
                                                        $count = 1;
                                                        foreach ($courts as $cat) {
                                                            ?>
                                                            <tr>
                                                                <td><?php echo $count++; ?></td>

                                                                <td><?php echo $cat['court_name']; ?></td>
                                                                <td>
                                                                    <?php if ($cat['court_status'] == 1) { ?>
                                                                        <a href="#" class="badge badge-secondary">Active</a>
                                                                    <?php } else { ?>
                                                                        <a href="#" class="badge badge-secondary">Disabled</a>
                                                                    <?php } ?>
                                                                </td>
                                                                <td>
                                                                    <?php if ($cat['court_status'] == 0) { ?>
                                                                        <a href="<?php echo base_url('admin/courts/actionEnable/'); ?><?php echo $cat['court_key']; ?>" class="badge badge-warning text-white">Enable</a>
                                                                    <?php } else { ?>
                                                                        <a href="<?php echo base_url('admin/courts/actionDisable/'); ?><?php echo $cat['court_key']; ?>" class="badge badge-danger text-white">Disable</a>
                                                                    <?php } ?>
                                                                    <a href="<?php echo base_url('admin/courts/actionEdit/'); ?><?php echo $cat['court_key']; ?>" class="badge badge-primary">Edit</a>
                                                                    <a onclick="return confirm('Are you sure?')" href="<?php echo base_url('admin/courts/actionDelete/'); ?><?php echo $cat['court_key']; ?>" class="badge badge-danger">Delete</a>
                                                                </td>
                                                            </tr>
                                                        <?php } ?>
                                                    <?php } else { ?>
                                                        <tr>
                                                            <td colspan="10">Articles not found.</td>
                                                        </tr>
                                                    <?php } ?>
                                                </tbody>

                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?php $this->load->view('admin/partials/footer'); ?>
            </div>
        </div>
        <!-- CoreUI and necessary plugins-->
        <?php $this->load->view('admin/partials/scripts'); ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });
        </script>
    </body>
</html>