<!DOCTYPE html>
<html lang="en">
    <?php $this->load->view('admin/partials/header'); ?>
    <body class="c-app">
        <?php $this->load->view('admin/partials/sidenav'); ?>
        <div class="c-wrapper c-fixed-components">
            <?php $this->load->view('admin/partials/navbar'); ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Add Bare Act Section
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?php echo base_url('admin/sections'); ?>">Bare Act Sections List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?php $this->load->view('admin/partials/alerts'); ?>
                                            <form id="articleForm" method="POST" action="<?php echo base_url('admin/sections/actionAddSection'); ?>" enctype="multipart/form-data">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Bare Act:</label>
                                                            <select required="" class="form-control" name="bareact">
                                                                <option selected="" value="" disabled="">Select Bare Act</option>
                                                                <?php foreach ($bareacts as $key => $bareact) { ?>
                                                                    <option value="<?php echo $bareact['ba_key']; ?>"><?php echo $bareact['ba_title']; ?></option>
                                                                <?php } ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Title:</label>
                                                            <input required="" name="title" id="title" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Particulars:</label>
                                                            <input required="" name="particular" id="particular" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Sub Title:</label>
                                                            <input name="subtitle" id="subtitle" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Sub Particulars:</label>
                                                            <input name="subparticular" id="subparticular" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <table id="myTable" class="table order-list table-responsive-sm table-hover table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>Title</th>
                                                                    <th>Content</th>
                                                                    <th></th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    <td>
                                                                        <textarea required="" name="data[1][]" class="form-control" rows="5"></textarea>
                                                                    </td>
                                                                    <td>
                                                                        <textarea required="" name="data[1][]" class="form-control" rows="5"></textarea>
                                                                    </td>
                                                                    <td>
                                                                        <a class="deleteRow"></a>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                            <tfoot>
                                                                <tr>
                                                                    <td colspan="5" style="text-align: left;">
                                                                        <input type="button" class="btn btn-info btn-block" id="addrow" value="Add Another Section" />
                                                                    </td>
                                                                </tr>
                                                            </tfoot>
                                                        </table>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?php $this->load->view('admin/partials/footer'); ?>
            </div>
        </div>
        <!-- CoreUI and necessary plugins-->
        <?php $this->load->view('admin/partials/scripts'); ?>

        <script>
            $(document).ready(function () {
                var counter = 2;

                $("#addrow").on("click", function () {
                    var rowCount = $('#myTable tr').length;
                    var count = rowCount;
                    var newRow = $("<tr>");
                    var cols = "";

                    cols += '<td><textarea name="data[' + counter + '][]" class="form-control" rows="5"></textarea></td>';
                    cols += '<td><textarea name="data[' + counter + '][]" class="form-control" rows="5"></textarea></td>';

                    cols += '<td><input type="button" class="ibtnDel btn btn-danger"  value="Delete"></td>';
                    newRow.append(cols);
                    $("table.order-list").append(newRow);
                    counter++;
                });

                $("table.order-list").on("click", ".ibtnDel", function (event) {
                    $(this).closest("tr").remove();
                    counter -= 1
                });


            });

            function calculateRow(row) {
                var price = +row.find('input[name^="price"]').val();

            }

            function calculateGrandTotal() {
                var grandTotal = 0;
                $("table.order-list").find('input[name^="price"]').each(function () {
                    grandTotal += +$(this).val();
                });
                $("#grandtotal").text(grandTotal.toFixed(2));
            }
        </script>
    </body>
</html>