<!DOCTYPE html>
<html lang="en">
    <?php $this->load->view('admin/partials/header'); ?>
    <body class="c-app">
        <?php $this->load->view('admin/partials/sidenav'); ?>
        <div class="c-wrapper c-fixed-components">
            <?php $this->load->view('admin/partials/navbar'); ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Add Judgement
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?php echo base_url('admin/judgements'); ?>">Judgements List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?php $this->load->view('admin/partials/alerts'); ?>
                                            <form id="articleForm" method="POST" action="<?php echo base_url('admin/judgements/actionAddJudgement'); ?>" enctype="multipart/form-data">
                                                <img id="previewImage" height="400" class="card-img-top" src="https://via.placeholder.com/800x400" alt="Judgement Image">
                                                <div class="row mt-3">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1">Image</label>
                                                            <input required="" name="image" id="image" type="file" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1">Tag</label>
                                                            <select required="" class="form-control" id="category" name="category">
                                                                <?php if (!empty($categories)) { ?>
                                                                    <option selected="" disabled="">Select Tag</option>
                                                                    <?php foreach ($categories as $cat) {
                                                                        ?>
                                                                        <option value="<?php echo $cat['category_key'] ?>"><?php echo $cat['category'] ?></option>
                                                                    <?php } ?>
                                                                <?php } else { ?>
                                                                    <option selected="" disabled="">No Tags</option>
                                                                <?php } ?>
                                                            </select>
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1">Author</label>
                                                            <select required="" class="form-control" id="author" name="author">
                                                                <?php if (!empty($authors)) { ?>
                                                                    <option selected="" disabled="">Select Author</option>
                                                                    <?php foreach ($authors as $author) {
                                                                        ?>
                                                                        <option value="<?php echo $author['author_key'] ?>"><?php echo $author['author_name'] ?></option>
                                                                    <?php } ?>
                                                                <?php } else { ?>
                                                                    <option selected="" disabled="">No Authors</option>
                                                                <?php } ?>
                                                            </select>
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1">Date</label>
                                                            <input required="" name="date" id="date" type="date" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1">Attachment</label>
                                                            <input name="attachment" id="attachment" type="file" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Title:</label>
                                                            <input required="" name="title" id="title" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Content:</label>
                                                            <textarea class="form-control" name="description" id="editor" required="required"><?php echo html_entity_decode($desc); ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?php $this->load->view('admin/partials/footer'); ?>
            </div>
        </div>
        <!-- CoreUI and necessary plugins-->
        <?php $this->load->view('admin/partials/scripts'); ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#previewImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#image").change(function () {
                readURL(this);
            });
        </script>
    </body>
</html>